/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Color;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import java.util.Vector;

public class Utilities
implements Serializable {
    private static final long serialVersionUID = -6728141251448819696L;

    public static Color getColorFromRGB(String descS) {
        StringTokenizer st = new StringTokenizer(descS, ",");
        if (st.nextToken().equals("RGB")) {
            int r = Integer.parseInt(st.nextToken());
            int g = Integer.parseInt(st.nextToken());
            int b = Integer.parseInt(st.nextToken());
            return new Color(r, g, b);
        }
        System.out.println("Utilities::getColorFromRGB (bad definition of the color, TYP missing (ex RGB,...)");
        System.exit(1);
        return new Color(0, 0, 0);
    }

    public static String shortName(Object obj) {
        int nbBarre = 4;
        StringTokenizer st = new StringTokenizer(obj.getClass().getName(), ".");
        String name = "";
        while (st.hasMoreTokens()) {
            name = st.nextToken();
        }
        int taille = name.length();
        if (taille <= 2 * nbBarre) {
            return name;
        }
        int cpt = 0;
        int i = 0;
        while (i < taille) {
            if (Character.isUpperCase(name.charAt(i))) {
                cpt = i;
            }
            ++i;
        }
        String s1 = "";
        String s2 = "";
        int d1 = 0;
        int l1 = StrictMath.min(nbBarre, cpt);
        int d2 = cpt;
        int l2 = StrictMath.min(nbBarre, taille - cpt);
        boolean touched = false;
        if (l1 != nbBarre) {
            l2 += nbBarre - l1;
            touched = true;
        }
        if (l2 != nbBarre && !touched) {
            l1 += nbBarre - l2;
        }
        s1 = name.substring(d1, d1 + l1);
        s2 = name.substring(d2, d2 + l2);
        return String.valueOf(s1) + s2;
    }

    public static String roundValue(double val, int nbValAfterDot) {
        String pattern = "";
        int i = 0;
        while (i < nbValAfterDot) {
            pattern = String.valueOf(pattern) + "0";
            ++i;
        }
        DecimalFormat form = new DecimalFormat("0." + pattern);
        String retour = form.format(val);
        return retour.replaceAll(",", ".");
    }

    public static String cutExtension(String fileName, String extension) {
        String retour = "";
        if (fileName.indexOf("." + extension) != -1) {
            StringTokenizer st = new StringTokenizer(fileName, ".");
            int nbTokens = st.countTokens();
            int j = 0;
            while (j < nbTokens - 2) {
                retour = String.valueOf(retour) + st.nextToken() + ".";
                ++j;
            }
            return String.valueOf(retour) + st.nextToken();
        }
        return fileName;
    }

    public static final void exceptionCaughtMessage(Exception e, Object classPointer, String methodName) {
        System.out.println(String.valueOf(classPointer.getClass().getName()) + "::" + methodName + " exception caught");
        e.printStackTrace();
        System.exit(1);
    }

    public static final void exceptionCaughtMessageInStaticContext(Exception e, String className, String methodName) {
        System.out.println(String.valueOf(className) + "::" + methodName + " exception caught");
        e.printStackTrace();
        System.exit(1);
    }

    public static String getMessageAndStackTrace(Exception e, int tabNb) {
        String retour = String.valueOf(e.getMessage()) + "\n";
        StackTraceElement[] stackTrace = e.getStackTrace();
        int i = 0;
        while (i < stackTrace.length) {
            int j = 0;
            while (j < tabNb) {
                retour = String.valueOf(retour) + "\t";
                ++j;
            }
            retour = String.valueOf(retour) + "at " + stackTrace[i] + "\n";
            ++i;
        }
        return retour;
    }

    public static final String vectorToString(Vector v) {
        String s = "[";
        int i = 0;
        while (i < v.size()) {
            s = String.valueOf(s) + v.get(i);
            if (i != v.size() - 1) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
        }
        s = String.valueOf(s) + "]";
        return s;
    }

    public static final String arrayToString(int[] a) {
        String s = "[";
        int i = 0;
        while (i < a.length) {
            s = String.valueOf(s) + a[i];
            if (i != a.length - 1) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
        }
        s = String.valueOf(s) + "]";
        return s;
    }

    public static final String arrayToString(int[] a, int[] b) {
        String s = "[";
        int i = 0;
        while (i < a.length) {
            s = String.valueOf(s) + a[i] + "(" + b[i] + ")";
            if (i != a.length - 1) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
        }
        s = String.valueOf(s) + "]";
        return s;
    }

    public static final String arrayToString(byte[] a) {
        String s = "[";
        int i = 0;
        while (i < a.length) {
            s = String.valueOf(s) + a[i];
            if (i != a.length - 1) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
        }
        s = String.valueOf(s) + "]";
        return s;
    }

    public static final String arrayToString(int[][] a, int[][] b) {
        String s = "";
        int i = 0;
        while (i < a.length) {
            s = String.valueOf(s) + "[";
            int j = 0;
            while (j < a[i].length) {
                s = String.valueOf(s) + a[i][j] + "(" + b[i][j] + ")";
                if (j != a[i].length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++j;
            }
            s = String.valueOf(s) + "]\n";
            ++i;
        }
        return s;
    }

    public static final String arrayToString(int[][] a) {
        String s = "";
        int i = 0;
        while (i < a.length) {
            s = String.valueOf(s) + "[";
            int j = 0;
            while (j < a[i].length) {
                s = String.valueOf(s) + a[i][j];
                if (j != a[i].length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++j;
            }
            s = String.valueOf(s) + "]\n";
            ++i;
        }
        return s;
    }

    public static final String arrayToString(double[][] a, double mult) {
        String s = "";
        double[][] a_clone = Utilities.tabClone(a);
        int i = 0;
        while (i < a_clone.length) {
            s = String.valueOf(s) + "[";
            int j = 0;
            while (j < a_clone[i].length) {
                s = String.valueOf(s) + String.format("%.5g", mult * a_clone[i][j]);
                if (j != a_clone[i].length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++j;
            }
            s = String.valueOf(s) + "]\n";
            ++i;
        }
        return s;
    }

    public static final String arrayToString(byte[][] a) {
        String s = "";
        int i = 0;
        while (i < a.length) {
            s = String.valueOf(s) + "[";
            int j = 0;
            while (j < a[i].length) {
                s = String.valueOf(s) + a[i][j];
                if (j != a[i].length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++j;
            }
            s = String.valueOf(s) + "]\n";
            ++i;
        }
        return s;
    }

    public static final byte[] tabClone(byte[] a) {
        byte[] retour = new byte[a.length];
        int i = 0;
        while (i < retour.length) {
            retour[i] = a[i];
            ++i;
        }
        return retour;
    }

    public static final byte[][] tabClone(byte[][] a) {
        byte[][] retour = new byte[a.length][];
        int i = 0;
        while (i < retour.length) {
            retour[i] = new byte[a[i].length];
            int j = 0;
            while (j < retour[i].length) {
                retour[i][j] = a[i][j];
                ++j;
            }
            ++i;
        }
        return retour;
    }

    public static final int[] tabClone(int[] a) {
        int[] retour = new int[a.length];
        int i = 0;
        while (i < retour.length) {
            retour[i] = a[i];
            ++i;
        }
        return retour;
    }

    public static final int[][] tabClone(int[][] a) {
        int[][] retour = new int[a.length][];
        int i = 0;
        while (i < retour.length) {
            retour[i] = new int[a[i].length];
            int j = 0;
            while (j < retour[i].length) {
                retour[i][j] = a[i][j];
                ++j;
            }
            ++i;
        }
        return retour;
    }

    public static final double[][] tabClone(double[][] a) {
        double[][] retour = new double[a.length][];
        int i = 0;
        while (i < retour.length) {
            retour[i] = new double[a[i].length];
            int j = 0;
            while (j < retour[i].length) {
                retour[i][j] = a[i][j];
                ++j;
            }
            ++i;
        }
        return retour;
    }

    public static final double[][][] tabClone(double[][][] a) {
        double[][][] retour = new double[a.length][][];
        int i = 0;
        while (i < retour.length) {
            retour[i] = new double[a[i].length][];
            int j = 0;
            while (j < retour[i].length) {
                retour[i][j] = new double[a[i][j].length];
                int k = 0;
                while (k < retour[i][j].length) {
                    retour[i][j][k] = a[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return retour;
    }
}

