/*
 * Decompiled with CFR 0.152.
 */
package utils;

import utils.Utilities;

public abstract class ReferenceConverter {
    protected double bottomLeftX;
    protected double bottomLeftY;
    protected double topRightX;
    protected double topRightY;
    protected double pixelBottomRightX;
    protected double pixelBottomRightY;
    protected double sizeX;
    protected double sizeY;
    protected double pixelCenterX;
    protected double pixelCenterY;

    public final int getPixelWidth() {
        return (int)this.pixelBottomRightX;
    }

    public final int getPixelHeight() {
        return (int)this.pixelBottomRightY;
    }

    public void init(double bottomLeftX, double bottomLeftY, double topRightX, double topRightY, double pixelBottomRightX, double pixelBottomRightY) {
        this.bottomLeftX = bottomLeftX;
        this.bottomLeftY = bottomLeftY;
        this.topRightX = topRightX;
        this.topRightY = topRightY;
        this.pixelBottomRightX = pixelBottomRightX;
        this.pixelBottomRightY = pixelBottomRightY;
        this.sizeX = topRightX - bottomLeftX;
        this.sizeY = topRightY - bottomLeftY;
        this.pixelCenterX = pixelBottomRightX / 2.0;
        this.pixelCenterY = pixelBottomRightY / 2.0;
    }

    public final String toString() {
        return "<" + Utilities.shortName(this) + " " + this.toShortString() + " " + Utilities.shortName(this) + ">";
    }

    public String toShortString() {
        String s = "";
        s = String.valueOf(s) + "bottomLeft(" + this.bottomLeftX + "," + this.bottomLeftY + ") ";
        s = String.valueOf(s) + "topRight(" + this.topRightX + "," + this.topRightY + ") ";
        s = String.valueOf(s) + "pixelBottomRight(" + this.pixelBottomRightX + "," + this.pixelBottomRightY + ")";
        return s;
    }

    public final int widthPixel() {
        return (int)this.pixelBottomRightX;
    }

    public final int heightPixel() {
        return (int)this.pixelBottomRightY;
    }

    public final int pixelCenterX() {
        return (int)StrictMath.rint(this.pixelCenterX);
    }

    public final int pixelCenterY() {
        return (int)StrictMath.rint(this.pixelCenterY);
    }

    public final double getCellWidth() {
        return this.sizeX / this.pixelBottomRightX;
    }

    public final double getCellHeight() {
        return this.sizeY / this.pixelBottomRightY;
    }

    public abstract int xPixel(double var1);

    public abstract int yPixel(double var1);

    public abstract double xBasic(double var1);

    public abstract double yBasic(double var1);

    public abstract int xPixelDist(double var1);

    public abstract int yPixelDist(double var1);

    public abstract double xBasicDist(int var1);

    public abstract double yBasicDist(double var1);
}

