/*
 * Decompiled with CFR 0.152.
 */
package utils;

import utils.ReferenceConverter;

public class GridReferenceConverter
extends ReferenceConverter {
    public boolean isGridVerticalInRightCell;
    protected double pixelHalfSizeX;
    protected double pixelHalfSizeY;

    public GridReferenceConverter(boolean isGridVerticalInRightCell) {
        this.isGridVerticalInRightCell = isGridVerticalInRightCell;
    }

    public final void init(double bottomLeftX, double bottomLeftY, double topRightX, double topRightY, double pixelBottomRightX, double pixelBottomRightY) {
        super.init(bottomLeftX, bottomLeftY, topRightX, topRightY, pixelBottomRightX, pixelBottomRightY);
        this.pixelHalfSizeX = this.sizeX / (2.0 * pixelBottomRightX);
        this.pixelHalfSizeY = this.sizeY / (2.0 * pixelBottomRightY);
        this.pixelHalfSizeX = this.isGridVerticalInRightCell ? (this.pixelHalfSizeX -= 1.0E-5) : (this.pixelHalfSizeX += 1.0E-5);
    }

    public final int xPixel(double xBasic) {
        return (int)StrictMath.rint(this.pixelBottomRightX * (xBasic - this.bottomLeftX - this.pixelHalfSizeX) / this.sizeX);
    }

    public final int yPixel(double yBasic) {
        return (int)StrictMath.rint(this.pixelBottomRightY - this.pixelBottomRightY * (yBasic - this.bottomLeftY + this.pixelHalfSizeY) / this.sizeY);
    }

    public final double xBasic(double xPixel) {
        return this.bottomLeftX + xPixel * this.sizeX / this.pixelBottomRightX + this.pixelHalfSizeX;
    }

    public final double yBasic(double yPixel) {
        return (this.pixelBottomRightY - yPixel) * this.sizeY / this.pixelBottomRightY + this.bottomLeftY - this.pixelHalfSizeY;
    }

    public final int xPixelDist(double xBasicDist) {
        return (int)StrictMath.rint(xBasicDist * this.pixelBottomRightX / this.sizeX);
    }

    public final int yPixelDist(double yBasicDist) {
        return (int)StrictMath.rint(yBasicDist * this.pixelBottomRightY / this.sizeY);
    }

    public final double xBasicDist(int xPixelDist) {
        return (double)xPixelDist * this.sizeX / this.pixelBottomRightX;
    }

    public final double yBasicDist(double yPixelDist) {
        return yPixelDist * this.sizeY / this.pixelBottomRightY;
    }

    public final boolean isPixelPosInsideTheGrid(int xPixel, int yPixel) {
        return xPixel >= 0 && xPixel < this.getPixelWidth() && yPixel >= 0 && yPixel < this.getPixelHeight();
    }

    public final boolean isBasicPosInsideTheGrid(double xBasic, double yBasic) {
        int xPixel = this.xPixel(xBasic);
        int yPixel = this.yPixel(yBasic);
        return xPixel >= 0 && xPixel < this.getPixelWidth() && yPixel >= 0 && yPixel < this.getPixelHeight();
    }
}

