/*
 * Decompiled with CFR 0.152.
 */
package utils;

import engine.RandomVariable;
import java.util.Hashtable;
import utils.GridAnalyticFunction1D;
import utils.GridReferenceConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridDistanceFunction1D
extends GridAnalyticFunction1D {
    private static final long serialVersionUID = -6212032014884429800L;

    @Override
    public final double computeValueFor(Hashtable<String, RandomVariable> vars, GridReferenceConverter rConv) throws Exception {
        double x = rConv.xBasic(this.getPar1(vars).getListVar(0));
        double y = rConv.yBasic(this.getPar1(vars).getListVar(1));
        int s = this.getPar1(vars).getListVar(2);
        double sx = rConv.xBasic(this.getPar2(vars).getListVar(0));
        double sy = rConv.yBasic(this.getPar2(vars).getListVar(1));
        int ss = this.getPar2(vars).getListVar(2);
        double[][] params = this.getFunctionParameters();
        double attract = 1.0;
        double coeff = 1.0;
        double base = 1.0E-4;
        if (params.length >= 1) {
            coeff = params[0][0];
        }
        if (params.length >= 2) {
            attract = params[1][0];
        }
        if (params.length >= 3) {
            base = params[2][0];
        }
        if (s != ss) {
            return base;
        }
        if ((double)this.getPar3(vars).getListVar(0) == attract) {
            return base + 1.0 / (coeff + (StrictMath.pow(sx - x, 2.0) + StrictMath.pow(sy - y, 2.0)));
        }
        return base + 1.0 - 1.0 / (coeff + (StrictMath.pow(sx - x, 2.0) + StrictMath.pow(sy - y, 2.0)));
    }

    @Override
    public final void reset(Hashtable<String, RandomVariable> vars, Object param) {
    }
}

