/*
 * Decompiled with CFR 0.152.
 */
package utils;

import engine.RandomVariable;
import java.util.Hashtable;
import utils.GridAnalyticFunction1D;
import utils.GridReferenceConverter;
import utils.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BetaDistributionFunction1D
extends GridAnalyticFunction1D {
    private static final long serialVersionUID = -6212032014884429800L;
    private static final double[] LN_GAMMA_FUNCTION_COEFS = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private static double mymin = -StrictMath.log(0.0);
    private static double mymax = StrictMath.log(0.0);
    private static double mymean = 0.0;
    private static long mynb = 0L;

    public static void printStats() {
        System.out.println("Min: " + mymin + "\t Max: " + mymax + "\t Mean: " + mymean);
    }

    @Override
    public final double computeValueFor(Hashtable<String, RandomVariable> vars, GridReferenceConverter rConv) throws Exception {
        double x = rConv.xBasic(this.getPar1(vars).getListVar(0));
        double y = rConv.yBasic(this.getPar1(vars).getListVar(1));
        int s = this.getPar1(vars).getListVar(2);
        double x_m = rConv.xBasic(this.getPar2(vars).getListVar(0));
        double y_m = rConv.yBasic(this.getPar2(vars).getListVar(1));
        int s_m = this.getPar2(vars).getListVar(2);
        double i = this.getPar3(vars).getRealVal();
        double p0 = this.getFunctionParameters()[0][0];
        double p1 = this.getFunctionParameters()[1][0];
        double p2 = this.getFunctionParameters()[2][0];
        Position pos = new Position(x, y, false);
        Position pos_m = new Position(x_m, y_m, false);
        double distance = StrictMath.sqrt(StrictMath.pow(pos.getX1() - pos_m.getX1(), 2.0) + StrictMath.pow(pos.getY1() - pos_m.getY1(), 2.0));
        double alpha = s == s_m ? 1.0 + p0 / (1.0 + p2 * StrictMath.pow(distance, p1)) : 1.0;
        mymin = StrictMath.min(mymin, alpha);
        mymax = StrictMath.max(mymax, alpha);
        mymean = ((double)mynb * mymean + alpha) / (double)(mynb + 1L);
        ++mynb;
        double proba = StrictMath.pow(1.0 - i, alpha - 1.0) * StrictMath.pow(i, alpha - 1.0) * this.betaFct(alpha, alpha);
        return proba;
    }

    @Override
    public final void reset(Hashtable<String, RandomVariable> vars, Object param) {
    }

    private final double lnGammaFct(double x) {
        double x_0;
        double y_0 = x_0 = x;
        double tmp = x_0 + 5.5 - (x_0 + 0.5) * StrictMath.log(x_0 + 5.5);
        double ser = 1.000000000190015;
        int j = 0;
        while (j <= 5) {
            ser += LN_GAMMA_FUNCTION_COEFS[j] / (y_0 += 1.0);
            ++j;
        }
        return StrictMath.log(2.5066282746310007 * ser / x_0) - tmp;
    }

    private final double lnBetaFct(double p, double q) {
        return this.lnGammaFct(p) + this.lnGammaFct(q) - this.lnGammaFct(p + q);
    }

    private final double betaFct(double p, double q) {
        return StrictMath.exp(this.lnBetaFct(p, q));
    }

    private final double gammaFct(double x) {
        return StrictMath.exp(this.lnGammaFct(x));
    }
}

