/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.Serializable;
import utils.Utilities;

public abstract class AnalyticFunction2D
implements Serializable {
    protected double[][] functionParameters;

    public final double[][] getFunctionParameters() {
        return this.functionParameters;
    }

    protected final void setFunctionParameters(double[][] params) {
        this.functionParameters = params;
    }

    public final double getMaxPositiveValue() {
        double retour = Double.MIN_VALUE;
        double[][] params = this.getFunctionParameters();
        int i = 0;
        while (i < params.length) {
            int j = 0;
            while (j < params[i].length) {
                if (StrictMath.abs(params[i][j]) > retour) {
                    retour = StrictMath.abs(params[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return retour;
    }

    public final String toString() {
        return "<" + this.getClass().getName() + " " + this.toShortString() + " " + this.getClass().getName() + ">";
    }

    public final String toShortString() {
        String s = "";
        double[][] params = this.getFunctionParameters();
        int i = 0;
        while (i < params.length) {
            if (params[0].length != 1) {
                s = String.valueOf(s) + "(";
            }
            int j = 0;
            while (j < params[i].length) {
                s = String.valueOf(s) + params[i][j];
                if (j < params[i].length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++j;
            }
            if (params[0].length != 1) {
                s = String.valueOf(s) + ")";
            }
            if (i < params.length - 1) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
        }
        return s;
    }

    public static final AnalyticFunction2D createFunction(String type, String params) {
        AnalyticFunction2D retour = null;
        String msg1 = "AnalyticFunction2D::createFunction";
        String msg2 = "createFunction";
        try {
            retour = (AnalyticFunction2D)Class.forName("utils." + type).newInstance();
        }
        catch (IllegalAccessException e) {
            Utilities.exceptionCaughtMessageInStaticContext(e, msg1, msg2);
        }
        catch (ClassNotFoundException e) {
            Utilities.exceptionCaughtMessageInStaticContext(e, msg1, msg2);
        }
        catch (InstantiationException e) {
            Utilities.exceptionCaughtMessageInStaticContext(e, msg1, msg2);
        }
        retour.init(params);
        return retour;
    }

    public abstract void init(String var1);

    public abstract double[] computeValueFor();

    public abstract double[] computeValueFor(double var1);

    public abstract double[] computeValueFor(double[] var1);
}

