/*
 * Decompiled with CFR 0.152.
 */
package utils;

import engine.RandomVariable;
import java.io.Serializable;
import java.util.Hashtable;
import utils.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnalyticFunction1D
implements Serializable {
    private String[] myParamNames;
    protected double[][] functionParameters;

    private final String[] getParamNames() {
        return this.myParamNames;
    }

    private final String getParamName(int index) {
        return this.myParamNames[index];
    }

    protected final void setParamNames(String[] usedVariableNames) {
        this.myParamNames = usedVariableNames;
    }

    public final double[][] getFunctionParameters() {
        return this.functionParameters;
    }

    protected final void setFunctionParameters(double[][] params) {
        this.functionParameters = params;
    }

    public final double getMaxPositiveValue() {
        double retour = Double.MIN_VALUE;
        double[][] params = this.getFunctionParameters();
        int i = 0;
        while (i < params.length) {
            int j = 0;
            while (j < params[i].length) {
                if (StrictMath.abs(params[i][j]) > retour) {
                    retour = StrictMath.abs(params[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return retour;
    }

    public final String toString() {
        return "<" + this.getClass().getName() + this.toShortString() + ">";
    }

    private final String toShortString() {
        String s = " f(";
        int i = 0;
        while (i < this.getParamNames().length) {
            s = String.valueOf(s) + this.getParamName(i);
            s = i != this.getParamNames().length - 1 ? String.valueOf(s) + ", " : String.valueOf(s) + ") parameters:";
            ++i;
        }
        double[][] params = this.getFunctionParameters();
        if (params != null) {
            int i2 = 0;
            while (i2 < params.length) {
                if (params[0].length != 1) {
                    s = String.valueOf(s) + "(";
                }
                int j = 0;
                while (j < params[i2].length) {
                    s = String.valueOf(s) + params[i2][j];
                    if (j < params[i2].length - 1) {
                        s = String.valueOf(s) + ", ";
                    }
                    ++j;
                }
                if (params[0].length != 1) {
                    s = String.valueOf(s) + ")";
                }
                if (i2 < params.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i2;
            }
        }
        return s;
    }

    public static final AnalyticFunction1D createFunction(String type, String params, String usedVarNames) {
        String msg1 = "AnalyticFunction1D::createFunction";
        String msg2 = "init";
        AnalyticFunction1D retour = null;
        try {
            retour = (AnalyticFunction1D)Class.forName("utils." + type).newInstance();
        }
        catch (IllegalAccessException e) {
            Utilities.exceptionCaughtMessageInStaticContext(e, msg1, msg2);
        }
        catch (ClassNotFoundException e) {
            Utilities.exceptionCaughtMessageInStaticContext(e, msg1, msg2);
        }
        catch (InstantiationException e) {
            Utilities.exceptionCaughtMessageInStaticContext(e, msg1, msg2);
        }
        super.init(params, usedVarNames);
        return retour;
    }

    protected final RandomVariable getPar1(Hashtable<String, RandomVariable> vars) {
        return this.getPar(vars, 0);
    }

    protected final RandomVariable getPar2(Hashtable<String, RandomVariable> vars) {
        return this.getPar(vars, 1);
    }

    protected final RandomVariable getPar3(Hashtable<String, RandomVariable> vars) {
        return this.getPar(vars, 2);
    }

    protected final RandomVariable getPar4(Hashtable<String, RandomVariable> vars) {
        return this.getPar(vars, 3);
    }

    protected final RandomVariable getPar5(Hashtable<String, RandomVariable> vars) {
        return this.getPar(vars, 4);
    }

    protected final RandomVariable getPar6(Hashtable<String, RandomVariable> vars) {
        return this.getPar(vars, 5);
    }

    private final RandomVariable getPar(Hashtable<String, RandomVariable> vars, int parNb) {
        if (parNb > this.getParamNames().length - 1) {
            System.out.println("AnalyticFunction1D (" + this.getClass().getName() + ") ::getPar" + "error: there is only " + this.getParamNames().length + " parameters (can't get" + " the " + parNb + "th)");
            System.exit(1);
            return null;
        }
        RandomVariable var = vars.get(this.getParamName(parNb));
        if (var != null) {
            return var;
        }
        System.out.println("AnalyticFunction1D (" + this.getClass().getName() + ") ::getPar" + parNb + " -error:" + this.getParamName(parNb) + " variable does not exist\n" + vars);
        System.exit(1);
        return null;
    }

    private final void init(String params, String usedVarNames) {
        if (!params.equals("")) {
            String[] pars1 = params.split("\\|");
            double[][] parameters = new double[pars1.length][];
            int i = 0;
            while (i < pars1.length) {
                String[] pars2 = pars1[i].split(",");
                parameters[i] = new double[pars2.length];
                int j = 0;
                while (j < pars2.length) {
                    parameters[i][j] = Double.parseDouble(pars2[j]);
                    ++j;
                }
                ++i;
            }
            this.setFunctionParameters(parameters);
        }
        this.setParamNames(usedVarNames.split("#"));
    }

    public abstract double computeValueFor(Hashtable<String, RandomVariable> var1, Object var2) throws Exception;

    public abstract void reset(Hashtable<String, RandomVariable> var1, Object var2);
}

