/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MVC_Event;
import gui.MVC_Event_Type;
import gui.MapView;
import gui.Model;
import gui.Spot;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseWheelEvent;
import utils.ClassicReferenceConverter;
import utils.Position;

public class VisualFieldMapView
extends MapView {
    private static final long serialVersionUID = -2178505912528421547L;

    public VisualFieldMapView() {
        this.setRefConverter(new ClassicReferenceConverter());
        this.setMinimumSize(new Dimension(0, 0));
    }

    protected final void subActualiseSize() {
        if (this.getCenterPointView() == null) {
            this.setZoom(1.0);
            this.setCenterPointView(new Position(0.0, 0.0, false));
        }
        this.getRefConverter().init(-150.0 / this.getZoom(), -90.0 / this.getZoom(), 150.0 / this.getZoom(), 90.0 / this.getZoom(), this.getWidth(), this.getHeight());
    }

    public void paint(Graphics g) {
        double[] circles_values = new double[]{5.0, 10.0, 20.0, 40.0, 80.0};
        double max_circles = circles_values[circles_values.length - 1];
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(Color.white);
        Font font = g2.getFont();
        g2.setFont(font.deriveFont(this.getFontSize()));
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setPaint(Color.black);
        int xcenter = this.getRefConverter().pixelCenterX();
        int posy_max_h = this.getRefConverter().yPixel(max_circles);
        int posy_max_b = this.getRefConverter().yPixel(-max_circles);
        int posx_max_d = this.getRefConverter().xPixel(max_circles);
        int posx_max_g = this.getRefConverter().xPixel(-max_circles);
        g2.drawLine(xcenter, posy_max_h, xcenter, posy_max_b);
        g2.drawLine(xcenter, posy_max_h, posx_max_d, posy_max_h);
        g2.drawLine(xcenter, posy_max_b, posx_max_d, posy_max_b);
        int i = 0;
        while (i < circles_values.length) {
            double crt_val = circles_values[i];
            int posxg = this.getRefConverter().xPixel(-crt_val);
            int posxd = this.getRefConverter().xPixel(crt_val);
            int posyh = this.getRefConverter().yPixel(crt_val);
            int posyb = this.getRefConverter().yPixel(-crt_val);
            int dimx = this.getRefConverter().xPixelDist(2.0 * crt_val);
            int dimy = this.getRefConverter().yPixelDist(2.0 * crt_val);
            g2.drawArc(posxg, posyh, dimx, dimy, -90, 360);
            g2.drawLine(xcenter - 10, posyh, xcenter, posyh);
            g2.drawLine(xcenter - 10, posyb, xcenter, posyb);
            g2.drawString(String.format("%2.0f", crt_val), xcenter - 12, posyh - 2);
            g2.drawString(String.format("%2.0f", -crt_val), xcenter - 18, posyb + 10);
            g2.drawLine(posxd, posy_max_h, posxd, posy_max_h + 5);
            g2.drawLine(posxd, posy_max_b, posxd, posy_max_b - 5);
            g2.drawString(String.format("%2.0f", crt_val), posxd - 5, posy_max_b + 12);
            ++i;
        }
        int ycenter = this.getRefConverter().pixelCenterY();
        int x45deg = this.getRefConverter().xPixelDist(max_circles * StrictMath.cos(0.7853981633974483));
        int y45deg = this.getRefConverter().yPixelDist(max_circles * StrictMath.sin(0.7853981633974483));
        Stroke basicSt = g2.getStroke();
        g2.setStroke(this.getDashedStroked(5.0f));
        g2.drawLine(posx_max_g, ycenter, posx_max_d, ycenter);
        g2.drawLine(xcenter, ycenter, xcenter + x45deg, ycenter + y45deg);
        g2.drawLine(xcenter, ycenter, xcenter + x45deg, ycenter - y45deg);
        g2.drawLine(xcenter, ycenter, xcenter - x45deg, ycenter + y45deg);
        g2.drawLine(xcenter, ycenter, xcenter - x45deg, ycenter - y45deg);
        g2.setStroke(basicSt);
        this.paintSpots(g2);
    }

    protected void paintObservation(Spot crtS, int[] pos, Graphics2D g2) {
        g2.fillArc(pos[0] - crtS.xSize / 2, pos[1] - crtS.ySize / 2, crtS.xSize, crtS.ySize, 0, 360);
        g2.setColor(Color.black);
        g2.drawArc(pos[0] - 3, pos[1] - 3, 6, 6, 0, 360);
        g2.drawLine(pos[0] - 6, pos[1], pos[0] + 6, pos[1]);
        g2.drawLine(pos[0], pos[1] - 6, pos[0], pos[1] + 6);
    }

    public boolean performedM_VC_Event(MVC_Event aM_VCEvt) {
        if (super.performedM_VC_Event(aM_VCEvt)) {
            return true;
        }
        switch (aM_VCEvt.getIdentity()) {
            case ZOOM_PLUS: {
                double zoom = (Double)aM_VCEvt.getData()[0][0];
                int hash = (Integer)aM_VCEvt.getData()[1][0];
                if (hash == this.hashCode()) {
                    this.setZoom(StrictMath.min(this.getZoom() * (1.0 + 0.05 * zoom), 20.0));
                    this.actualiseSize();
                    this.repaint();
                }
                return true;
            }
            case ZOOM_MOINS: {
                double zoom = (Double)aM_VCEvt.getData()[0][0];
                int hash = (Integer)aM_VCEvt.getData()[1][0];
                if (hash == this.hashCode()) {
                    this.setZoom(StrictMath.max(this.getZoom() * (1.0 - 0.05 * zoom), 0.05));
                    this.actualiseSize();
                    this.repaint();
                }
                return true;
            }
        }
        return false;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        Object[][] data = new Object[][]{{(double)e.getClickCount()}, {this.hashCode()}};
        if (e.getWheelRotation() > 0) {
            for (Model crtMd : this.getAssociatedModels()) {
                crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.ZOOM_PLUS, this, data));
            }
        } else {
            for (Model crtMd : this.getAssociatedModels()) {
                crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.ZOOM_MOINS, this, data));
            }
        }
    }

    protected final Position getPositionFromPixelCoord(int posx, int posy) {
        double x = this.getRefConverter().xBasic(posx);
        double y = this.getRefConverter().yBasic(posy);
        return new Position(x, y, true);
    }

    protected final int[] getPixelCoordFromPosition(Position pos) {
        int posx = this.getRefConverter().xPixel(pos.getX1());
        int posy = this.getRefConverter().yPixel(pos.getY1());
        int[] retour = new int[]{posx, posy};
        return retour;
    }
}

