/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.SpotType;
import java.awt.Color;
import utils.Position;

public class Spot {
    public boolean selected;
    public double size;
    public int xSize;
    public int ySize;
    public int refHashcode;
    public Position position;
    public SpotType type;
    public int time;
    public String label;

    public Spot(double size, int hashCode, Position pos, boolean isTarget) {
        this.size = size;
        this.refHashcode = hashCode;
        this.position = pos;
        this.selected = false;
        this.type = isTarget ? SpotType.TARGET : SpotType.OBSERVATION;
    }

    public Spot(int hashCode, Position pos, int t) {
        this.refHashcode = hashCode;
        this.position = pos;
        this.selected = false;
        this.type = SpotType.SACCADE;
        this.time = t;
    }

    public Spot(int hashCode, Position pos, String label) {
        this.refHashcode = hashCode;
        this.position = pos;
        this.selected = false;
        this.type = SpotType.MARK;
        this.label = label;
    }

    public final String toString() {
        String s = "<Spot type=" + (Object)((Object)this.type) + " label=\"" + this.label + "\" size=" + this.size;
        s = String.valueOf(s) + " hashCode=" + this.refHashcode;
        s = String.valueOf(s) + " selected=" + this.selected + ">";
        s = String.valueOf(s) + "\n\t" + this.position + "\n</Spot>";
        return s;
    }

    public final Color choosePaintColor(boolean traceLegend) {
        if (!this.selected) {
            switch (this.type) {
                case OBSERVATION: {
                    return Color.red;
                }
                case TARGET: {
                    return Color.magenta;
                }
                case SACCADE: {
                    return new Color(0, 180, 0);
                }
                case MARK: {
                    if (traceLegend) {
                        return Color.black;
                    }
                    return Color.white;
                }
            }
        } else {
            switch (this.type) {
                case OBSERVATION: {
                    return Color.orange;
                }
                case TARGET: {
                    return Color.pink;
                }
                case SACCADE: {
                    return new Color(100, 255, 100);
                }
                case MARK: {
                    if (traceLegend) {
                        return Color.black;
                    }
                    return Color.white;
                }
            }
        }
        return null;
    }
}

