/*
 * Decompiled with CFR 0.152.
 */
package gui;

import engine.GridProbabilisticDistribution;
import engine.LeftRight_GridProbabilisticDistribution;
import engine.RandomVariable;
import gui.GridColliculusMapView;
import gui.MVC_Event;
import java.util.Hashtable;
import java.util.Vector;
import utils.Utilities;

public class ProbabilityGridColliculusView
extends GridColliculusMapView {
    private static final long serialVersionUID = 1L;

    public ProbabilityGridColliculusView(String name, boolean isRightPart) {
        super(name, isRightPart);
    }

    public boolean performedM_VC_Event(MVC_Event aMVCEvt) {
        if (super.performedM_VC_Event(aMVCEvt)) {
            return true;
        }
        switch (aMVCEvt.getIdentity()) {
            case UPDATE: {
                Object[][] data = aMVCEvt.getData();
                GridProbabilisticDistribution gpd = this.getAssociatedElt(data);
                Hashtable<String, RandomVariable> vars = this.getVariables(data);
                try {
                    this.setValuesGrid(gpd.getProbaGrid(vars));
                    this.setProbaGlobal(gpd.isProbaGlobal());
                }
                catch (Exception e) {
                    Utilities.exceptionCaughtMessage(e, this, "performedM_VC_Event");
                }
                this.repaint();
                return true;
            }
        }
        return false;
    }

    private final GridProbabilisticDistribution getAssociatedElt(Object[][] data) {
        Vector probaList = (Vector)data[0][1];
        for (LeftRight_GridProbabilisticDistribution p : probaList) {
            if (this.isRightPart()) {
                if (!p.getRightPart().getName().equals(this.getAssociatedEltName())) continue;
                double[] minMax = p.getMinMax();
                this.setMinProba(minMax[0]);
                this.setMaxProba(minMax[1]);
                return p.getRightPart();
            }
            if (!p.getLeftPart().getName().equals(this.getAssociatedEltName())) continue;
            double[] minMax = p.getMinMax();
            this.setMinProba(minMax[0]);
            this.setMaxProba(minMax[1]);
            return p.getLeftPart();
        }
        return null;
    }
}

