/*
 * Decompiled with CFR 0.152.
 */
package gui;

import engine.Cell;
import engine.RandomVariable;
import gui.ColliculusMapView;
import gui.MVC_Event;
import gui.MVC_Event_Type;
import gui.Model;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import utils.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GridColliculusMapView
extends ColliculusMapView {
    private String myAssociatedEltName;
    private double myCellWidth;
    private double myCellHeight;
    private double[] myGridXRange;
    private double[] myGridYRange;
    private static final long serialVersionUID = 7778342071137700533L;
    private double[][] myValuesGrid;
    private int myGridWidth;
    private int myGridHeight;
    private boolean probaGlobal;
    private double minProba;
    private double maxProba;

    public boolean isProbaGlobal() {
        return this.probaGlobal;
    }

    public void setProbaGlobal(boolean isProbaGlobal) {
        this.probaGlobal = isProbaGlobal;
    }

    public double getMaxProba() {
        return this.maxProba;
    }

    public void setMaxProba(double maxProba) {
        this.maxProba = maxProba;
    }

    public double getMinProba() {
        return this.minProba;
    }

    public void setMinProba(double minProba) {
        this.minProba = minProba;
    }

    protected final String getAssociatedEltName() {
        return this.myAssociatedEltName;
    }

    private final void setAssociatedEltName(String name) {
        this.myAssociatedEltName = name;
    }

    private final double getCellHeight() {
        return this.myCellHeight;
    }

    private final void setCellHeight(double cellHeight) {
        this.myCellHeight = cellHeight;
    }

    private final double getCellWidth() {
        return this.myCellWidth;
    }

    private final void setCellWidth(double cellWidth) {
        this.myCellWidth = cellWidth;
    }

    private final double[] getGridXRange() {
        return this.myGridXRange;
    }

    private final void setGridXRange(double[] gridXRange) {
        this.myGridXRange = gridXRange;
    }

    private final double[] getGridYRange() {
        return this.myGridYRange;
    }

    private final void setGridYRange(double[] gridYRange) {
        this.myGridYRange = gridYRange;
    }

    private final double[][] getValuesGrid() {
        return this.myValuesGrid;
    }

    protected final void setValuesGrid(double[][] valuesGrid) {
        this.myValuesGrid = valuesGrid;
    }

    protected int getGridHeight() {
        return this.myGridHeight;
    }

    private void setGridHeight(int gridHeight) {
        this.myGridHeight = gridHeight;
    }

    protected int getGridWidth() {
        return this.myGridWidth;
    }

    private void setGridWidth(int gridWidth) {
        this.myGridWidth = gridWidth;
    }

    public GridColliculusMapView(String associatedEltName, boolean isRightPart) {
        super(isRightPart);
        this.setCurvesColor(Color.cyan);
        this.setTraceLegendFlag(true);
        this.setAssociatedEltName(associatedEltName);
        this.setFontSize(9.0f);
    }

    @Override
    public void paint(Graphics g) {
        int i;
        double[] xrange = this.getGridXRange();
        double[] yrange = this.getGridYRange();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(Color.lightGray);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        double cellwid = this.getCellWidth();
        double cellhei = this.getCellHeight();
        int ybot_p = this.getRefConverter().yPixel(yrange[0]);
        int ytop_p = this.getRefConverter().yPixel(yrange[1]);
        int xlef_p = this.getRefConverter().xPixel(xrange[0]);
        int xrig_p = this.getRefConverter().xPixel(xrange[1]);
        Font font = g2.getFont();
        g2.setFont(font.deriveFont(this.getFontSize()));
        g2.setColor(new Color(0, 0, 180));
        g2.fillRect(xlef_p, ytop_p, xrig_p - xlef_p, ybot_p - ytop_p);
        double min = 0.0;
        double max = 1.0;
        if (this.getValuesGrid() != null) {
            if (this.isProbaGlobal()) {
                min = this.getMinProba();
                max = this.getMaxProba();
            }
            int cellwid_p = this.getRefConverter().xPixelDist(cellwid);
            int cellhei_p = this.getRefConverter().yPixelDist(cellhei);
            i = 0;
            while (i < this.getValuesGrid().length) {
                int j = 0;
                while (j < this.getValuesGrid()[i].length) {
                    double icell = (double)i * cellwid;
                    double jcell = (double)j * cellhei;
                    int celllef_p = this.getRefConverter().xPixel(xrange[0] + icell);
                    int celltop_p = this.getRefConverter().yPixel(yrange[1] - jcell);
                    g2.setColor(this.setProbaColor(this.getValuesGrid()[i][j], min, max));
                    g2.fillRect(celllef_p, celltop_p, cellwid_p, cellhei_p);
                    ++j;
                }
                ++i;
            }
        }
        double max_zoom = 4.0;
        if (this.getZoom() > max_zoom) {
            g2.setColor(Color.cyan);
        } else {
            g2.setColor(new Color(0, 0, 180));
        }
        i = 0;
        while (i <= this.getGridWidth()) {
            double pos_x2 = xrange[0] + (double)i * cellwid;
            int posx = this.getRefConverter().xPixel(pos_x2);
            if (this.getZoom() > max_zoom) {
                g2.drawLine(posx, 0, posx, this.getHeight());
                g2.drawString(String.format("%2.1f", pos_x2), posx, 15);
            } else {
                g2.drawLine(posx, ytop_p, posx, ybot_p);
            }
            ++i;
        }
        i = 0;
        while (i <= this.getGridHeight()) {
            double pos_y2 = yrange[0] + (double)i * cellhei;
            int posy = this.getRefConverter().yPixel(pos_y2);
            if (this.getZoom() > max_zoom) {
                g2.drawLine(0, posy, this.getWidth(), posy);
                g2.drawString(String.format("%2.1f", pos_y2), 0, posy);
            } else {
                g2.drawLine(xlef_p, posy, xrig_p, posy);
            }
            ++i;
        }
        if (this.getZoom() > max_zoom) {
            i = 0;
            while (i <= 2 * this.getGridWidth()) {
                int j = 0;
                while (j <= 2 * this.getGridHeight()) {
                    if (i % 2 == 1 && j % 2 == 1) {
                        double pos_x2 = xrange[0] + (double)i * cellwid / 2.0;
                        double pos_y2 = yrange[0] + (double)j * cellhei / 2.0;
                        int posx = this.getRefConverter().xPixel(pos_x2);
                        int posy = this.getRefConverter().yPixel(pos_y2);
                        g2.drawLine(posx - 2, posy, posx + 2, posy);
                        g2.drawLine(posx, posy - 2, posx, posy + 2);
                        Cell c = Cell.getCell(new Position(pos_x2, pos_y2, false));
                        if (c.isRight) {
                            g2.drawString(String.format("[%2d|%2d]*", c.x, c.y), posx + 3, posy + 10);
                        } else {
                            g2.drawString(String.format("*[%2d|%2d]", c.x, c.y), posx + 3, posy + 10);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.traceLogCurves(g2);
        this.paintSpots(g2);
        g2.setColor(Color.black);
        g2.drawString("t=" + this.getGridTimeStep(), 5, 15);
        this.paintLegend(g2, min, max);
    }

    private Color setProbaColor(double proba, double min, double max) {
        float p = (float)((proba - min) / max);
        try {
            if (p <= 0.33333334f) {
                return new Color(3.0f * p, 0.0f, 0.0f);
            }
            if (p <= 0.6666667f) {
                return new Color(1.0f, 3.0f * (p - 0.33333334f), 0.0f);
            }
            if (p <= 1.0f) {
                return new Color(1.0f, 1.0f, 3.0f * (p - 0.6666667f));
            }
            return new Color(0.0f, 1.0f, 1.0f);
        }
        catch (Exception e) {
            String pa = String.format("%2.2f, %2.2f, %2.2f", Float.valueOf(3.0f * p), Float.valueOf(0.0f), Float.valueOf(0.0f));
            String pb = String.format("%2.2f, %2.2f, %2.2f", Float.valueOf(1.0f), Float.valueOf(3.0f * (p - 0.33333334f)), Float.valueOf(0.0f));
            String pc = String.format("%2.2f, %2.2f, %2.2f", Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(3.0f * (p - 0.6666667f)));
            System.out.println("proba:" + proba + " \tp:" + p + " (min, max)=(" + min + ", " + max + "\n\ta]" + pa + "\n\tb]" + pb + "\n\tc]" + pc);
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    protected final Hashtable<String, RandomVariable> getVariables(Object[][] data) {
        Hashtable retour = (Hashtable)data[0][0];
        return retour;
    }

    @Override
    public boolean performedM_VC_Event(MVC_Event aMVCEvt) {
        if (super.performedM_VC_Event(aMVCEvt)) {
            return true;
        }
        switch (aMVCEvt.getIdentity()) {
            case INIT: {
                this.initGrid(aMVCEvt.getData());
                return true;
            }
        }
        return false;
    }

    private final void initGrid(Object[][] data) {
        this.setGridTimeStep(0);
        this.setGridHeight((Integer)data[0][2]);
        this.setCellWidth((Double)data[3][0]);
        this.setCellHeight((Double)data[3][1]);
        double[] yrange = new double[]{(Double)data[2][0], (Double)data[2][1]};
        this.setGridYRange(yrange);
        if (this.isRightPart()) {
            this.setGridWidth((Integer)data[0][1]);
            double[] xrange = new double[]{(Double)data[1][2], (Double)data[1][3]};
            this.setGridXRange(xrange);
        } else {
            this.setGridWidth((Integer)data[0][0]);
            double[] xrange = new double[]{(Double)data[1][0], (Double)data[1][1]};
            this.setGridXRange(xrange);
        }
    }

    private void paintLegend(Graphics2D g2, double min, double max) {
        int nb_grad = 20;
        int wHeight = this.getRefConverter().getPixelHeight();
        int wWidth = this.getRefConverter().getPixelWidth();
        int gradw = (int)StrictMath.rint(0.025 * (double)wWidth);
        int gradh = (int)StrictMath.rint(0.75 * (double)wHeight / (double)nb_grad);
        int gradxg = (int)StrictMath.rint(0.02 * (double)wWidth);
        int gradxd = (int)StrictMath.rint(0.045 * (double)wWidth);
        if (this.isRightPart()) {
            int tmp = gradxg;
            gradxg = wWidth - 35 - gradxd;
            gradxd = wWidth - 35 - tmp;
        }
        int gradyh = (int)StrictMath.rint(0.125 * (double)wHeight);
        Font font = g2.getFont();
        g2.setFont(font.deriveFont(this.getFontSize()));
        int i = 0;
        while (i <= nb_grad) {
            double proba = min + (1.0 - (double)i / (double)nb_grad) * (max - min);
            g2.setColor(Color.black);
            g2.drawString(String.format("%.3g", proba), gradxd + 2, gradyh + gradh / 2);
            g2.setColor(this.setProbaColor(proba, min, max));
            g2.fillRect(gradxg, gradyh, gradw, gradh);
            gradyh += gradh;
            ++i;
        }
        g2.setFont(font);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Object[][] data = new Object[][]{{this.getPositionFromPixelCoord(e.getX(), e.getY())}, {this.getAssociatedEltName()}};
        for (Model crtMd : this.getAssociatedModels()) {
            crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.INFOS, this, data));
        }
    }
}

