/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Controller;
import gui.MVC_Event;
import gui.MVC_Event_Type;
import gui.Model;
import gui.View;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.Timer;
import utils.ExampleFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BossToolBar
extends JToolBar
implements Controller,
ActionListener,
View {
    private Timer myTimer;
    private Vector<ImageIcon> myImageIcons;
    private Vector<AbstractButton> myButtons;
    private Vector<Model> myAssociatedModel = new Vector();

    private final void setTimer(Timer myT) {
        this.myTimer = myT;
    }

    private final Timer getTimer() {
        return this.myTimer;
    }

    private final void setImageIcons(Vector<ImageIcon> myICs) {
        this.myImageIcons = myICs;
    }

    private final void setImageIcons(ImageIcon myIC, int rank) {
        this.myImageIcons.setElementAt(myIC, rank);
    }

    private final ImageIcon getImageIcons(int rank) {
        return this.myImageIcons.get(rank);
    }

    private final Vector<AbstractButton> getButtons() {
        return this.myButtons;
    }

    private final void setButtons(Vector<AbstractButton> myBs) {
        this.myButtons = myBs;
    }

    private final void setButtons(AbstractButton myB, int rank) {
        this.myButtons.add(rank, myB);
    }

    private final AbstractButton getButtons(int rank) {
        return this.myButtons.get(rank);
    }

    @Override
    public Vector<Model> getAssociatedModels() {
        return this.myAssociatedModel;
    }

    public BossToolBar() {
        Dimension sepDim = new Dimension(15, 15);
        this.init(7);
        this.add(this.initButton(0, "Load an observation trajectories file", "Open16", false));
        this.add((Component)new JToolBar.Separator(sepDim), null);
        this.add(this.initButton(1, "Iterate observation trajectories", "Play16", false));
        this.add(this.initButton(2, "Pause", "Pause16", false));
        this.add(this.initButton(3, "Iterate one step", "StepForward16", false));
        this.add(this.initButton(4, "Reset observation trajectories", "Stop16", false));
        this.add((Component)new JToolBar.Separator(sepDim), null);
        this.add(this.initButton(5, "Fixed eyes", "Find16", true));
        this.add(this.initButton(6, "Model", "Export16", true));
        this.getButtons(6).setEnabled(false);
        this.setTimer(new Timer(0, this));
        this.getTimer().setInitialDelay(0);
        this.getTimer().setCoalesce(true);
    }

    private final void init(int nbJButtons) {
        Vector<AbstractButton> v1 = new Vector<AbstractButton>();
        Vector<ImageIcon> v2 = new Vector<ImageIcon>();
        int i = 0;
        while (i < nbJButtons) {
            v1.add(null);
            v2.add(null);
            ++i;
        }
        this.setButtons(v1);
        this.setImageIcons(v2);
    }

    private final AbstractButton initButton(int id, String toolTipText, String imageName, boolean toggle) {
        int width = 25;
        int height = 20;
        URL path = this.getClass().getResource("/icons/" + imageName + ".gif");
        this.setImageIcons(new ImageIcon(path), id);
        if (toggle) {
            this.setButtons(new JToggleButton(this.getImageIcons(id), false), id);
        } else {
            this.setButtons(new JButton(this.getImageIcons(id)), id);
        }
        this.getButtons(id).setMaximumSize(new Dimension(width, height));
        this.getButtons(id).setMinimumSize(new Dimension(width, height));
        this.getButtons(id).setPreferredSize(new Dimension(width, height));
        this.getButtons(id).setToolTipText(toolTipText);
        this.getButtons(id).addActionListener(this);
        return this.getButtons(id);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.getTimer())) {
            for (Model crtMd : this.getAssociatedModels()) {
                crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.ITERE, this, null));
            }
            try {
                Thread.sleep(5L);
            }
            catch (Exception crtMd) {}
        } else {
            int idBut = this.getButtons().indexOf(e.getSource());
            switch (idBut) {
                case 0: {
                    String file_path = this.chooseAFile("/trajectories", "observation trajectories file", "trj", "Observation trajectories files");
                    if (file_path == null) break;
                    for (Model crtMd : this.getAssociatedModels()) {
                        crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.LOAD, this, new Object[][]{{file_path}}));
                    }
                    break;
                }
                case 1: {
                    this.startAnimation();
                    break;
                }
                case 2: {
                    this.stopAnimation();
                    break;
                }
                case 3: {
                    for (Model crtMd : this.getAssociatedModels()) {
                        crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.ITERE, this, null));
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (Exception crtMd) {}
                    break;
                }
                case 4: {
                    this.stopAnimation();
                    for (Model crtMd : this.getAssociatedModels()) {
                        crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.RESET, this, null));
                    }
                    break;
                }
                case 5: {
                    boolean new_state = this.getButtons(idBut).isSelected();
                    MVC_Event event = new_state ? new MVC_Event(MVC_Event_Type.FREE_EYES, this, null) : new MVC_Event(MVC_Event_Type.FIXED_EYES, this, null);
                    for (Model crtMd : this.getAssociatedModels()) {
                        crtMd.performedVC_M_Event(event);
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (Exception crtMd) {}
                    break;
                }
                case 6: {
                    boolean new_state = this.getButtons(idBut).isSelected();
                    MVC_Event event = new_state ? new MVC_Event(MVC_Event_Type.MODEL_EM, this, null) : new MVC_Event(MVC_Event_Type.DATA_EM, this, null);
                    for (Model crtMd : this.getAssociatedModels()) {
                        crtMd.performedVC_M_Event(event);
                    }
                    try {
                        Thread.sleep(5L);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private final String chooseAFile(String path, String type, String ext, String fileDesc) {
        URL url = this.getClass().getResource(path);
        JFileChooser chooser = null;
        if (url == null) {
            chooser = new JFileChooser();
        } else {
            String[] urls = url.toString().split(":");
            chooser = new JFileChooser(urls[1]);
        }
        chooser.setDialogTitle("Load " + type);
        chooser.setApproveButtonText("Load");
        chooser.setApproveButtonToolTipText("Click to load the file");
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension(ext);
        filter.setDescription(fileDesc);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 1) {
            return null;
        }
        if (returnVal == 0) {
            String file_path = chooser.getSelectedFile().getPath();
            return file_path;
        }
        return null;
    }

    private synchronized void startAnimation() {
        if (!this.getTimer().isRunning()) {
            this.getTimer().start();
        }
    }

    private synchronized void stopAnimation() {
        if (this.getTimer().isRunning()) {
            this.getTimer().stop();
        }
    }

    @Override
    public boolean performedM_VC_Event(MVC_Event aMVCEvt) {
        aMVCEvt.traceDebug(String.valueOf(this.getClass().getName()) + "::performedM_VC_Event");
        switch (aMVCEvt.getIdentity()) {
            case START: {
                this.startAnimation();
                return true;
            }
            case STOP: {
                this.stopAnimation();
                return true;
            }
            case FREE_EYES: {
                this.getButtons(5).setToolTipText("Free eye movements");
                this.getButtons(6).setEnabled(true);
                return true;
            }
            case FIXED_EYES: {
                this.getButtons(5).setToolTipText("Fixed eyes");
                this.getButtons(6).setEnabled(false);
                return true;
            }
            case MODEL_EM: {
                this.getButtons(6).setToolTipText("Eye movements from model");
                return true;
            }
            case DATA_EM: {
                this.getButtons(6).setToolTipText("Eye movements from data");
                return true;
            }
        }
        return false;
    }
}

