/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.Antecedent;
import engine.BossEngine;
import engine.Cell;
import engine.FunctionProbabilisticDistribution;
import engine.GridPosDebugPolicy;
import engine.GridProbabilisticDistribution;
import engine.LeftRight_GridProbabilisticDistribution;
import engine.LeftRight_Variable;
import engine.Observation;
import engine.ProbabilisticDistribution;
import engine.RandomVariable;
import engine.ShowableException;
import engine.Target;
import gui.MVC_Event;
import gui.MVC_Event_Type;
import gui.View;
import java.util.Hashtable;
import utils.BetaDistributionFunction1D;
import utils.GridReferenceConverter;
import utils.Position;
import utils.Utilities;

public class V20_BossEngine
extends BossEngine {
    private static BossEngine uniqInstance = null;
    private Cell lastSaccadeCell;
    private double[][][] logPrior_Q2c;
    private boolean priorQ2c_ok;
    private double[][][] logPrior_Q2b;
    private boolean priorQ2b_ok;

    private V20_BossEngine() {
    }

    public static BossEngine getInstance() {
        if (uniqInstance == null) {
            uniqInstance = new V20_BossEngine();
            BossEngine.appliVersion = "2.0";
            uniqInstance.setDebugPolicy(new GridPosDebugPolicy());
        }
        return uniqInstance;
    }

    protected void getCellInfos(Position requestPos, String elementName) {
        Cell r_c = Cell.getCell(requestPos);
        String msg = "";
        if (r_c == null) {
            msg = "No cell !";
        } else {
            msg = "Cell (" + r_c.x + "," + r_c.y + ":" + r_c.side + ")";
            try {
                double val = 0.0;
                this.getVariable("(x, y)").setList(new int[]{r_c.x, r_c.y, r_c.side});
                this.getVariable("obj_{(x, y)}^t").setList(new int[]{1});
                val = r_c.isRight ? this.getGridProbaDists().get(1).getRightPart().getValue(this.getVariables()) : this.getGridProbaDists().get(1).getLeftPart().getValue(this.getVariables());
                msg = String.valueOf(msg) + " || P(obj^t~|~...) = " + val;
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "getCellInfos");
            }
            try {
                double val = 0.0;
                this.getVariable("(x, y)").setList(new int[]{r_c.x, r_c.y, r_c.side});
                this.getVariable("tgt_{(x, y)}^t").setList(new int[]{1});
                val = r_c.isRight ? this.getGridProbaDists().get(3).getRightPart().getValue(this.getVariables()) : this.getGridProbaDists().get(3).getLeftPart().getValue(this.getVariables());
                msg = String.valueOf(msg) + " || P(tgt^t~|~...) = " + val;
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "getCellInfos");
            }
            try {
                double val = 0.0;
                this.getVariable("Mot-c^t").setList(new int[]{r_c.x, r_c.y, r_c.side});
                val = r_c.isRight ? this.getGridProbaDists().get(6).getRightPart().getValue(this.getVariables()) : this.getGridProbaDists().get(6).getLeftPart().getValue(this.getVariables());
                msg = String.valueOf(msg) + " || P(Mot-c^t)" + val;
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "getCellInfos");
            }
            try {
                double val = 0.0;
                this.getVariable("Mot-b^t").setList(new int[]{r_c.x, r_c.y, r_c.side});
                val = r_c.isRight ? this.getGridProbaDists().get(8).getRightPart().getValue(this.getVariables()) : this.getGridProbaDists().get(8).getLeftPart().getValue(this.getVariables());
                msg = String.valueOf(msg) + " || P(Mot^t~|~normmod) = " + val;
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "getCellInfos");
            }
            try {
                double val = 0.0;
                this.getVariable("Mot-c^t").setList(new int[]{r_c.x, r_c.y, r_c.side});
                val = r_c.isRight ? this.getGridProbaDists().get(7).getRightPart().getValue(this.getVariables()) : this.getGridProbaDists().get(7).getLeftPart().getValue(this.getVariables());
                msg = String.valueOf(msg) + " || P(Mot^t~|~probmod) = " + val;
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "getCellInfos");
            }
        }
        for (View crtV : this.getAssociatedViews()) {
            crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.TOOLTIP_INFOS, this, msg, null));
        }
    }

    protected void initProbaDistributions() {
        GridReferenceConverter lc = Cell.leftGridRefConverter;
        GridReferenceConverter rc = Cell.rightGridRefConverter;
        double val_norm = 0.01;
        Hashtable<String, String> params = null;
        LeftRight_GridProbabilisticDistribution gpd0 = new LeftRight_GridProbabilisticDistribution("GPD_Table3D", lc, rc);
        params = new Hashtable<String, String>();
        params.put("searchNames", "Obj^{t-1}_{(x', y')}");
        params.put("knownNames", "Obs^{0:T-1}#Mvt^{0:T-1}");
        params.put("paramNames", "@obj_{(x', y')}^{t-1}:0#@(x', y'):0#@(x', y'):1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        gpd0.init(params);
        LeftRight_GridProbabilisticDistribution gpd1 = new LeftRight_GridProbabilisticDistribution("GPD_Table3D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Obj^t_{(x, y)}");
        params.put("knownNames", "Obs^{0:T}#Mvt^{0:T}");
        params.put("paramNames", "@obj_{(x, y)}^t:0#@(x, y):0#@(x, y):1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        gpd1.init(params);
        LeftRight_GridProbabilisticDistribution gpd2 = new LeftRight_GridProbabilisticDistribution("GPD_Table3D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Tgt^{t-1}_{(x', y')}");
        params.put("knownNames", "Obs^{0:T-1}#Mvt^{0:T-1}");
        params.put("paramNames", "@tgt_{(x', y')}^{t-1}:0#@(x', y'):0#@(x', y'):1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        gpd2.init(params);
        LeftRight_GridProbabilisticDistribution gpd3 = new LeftRight_GridProbabilisticDistribution("GPD_Table3D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Tgt^t_{(x, y)}");
        params.put("knownNames", "Obs^{0:T}#Mvt^{0:T}");
        params.put("paramNames", "@tgt_{(x, y)}^t:0#@(x, y):0#@(x, y):1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        gpd3.init(params);
        LeftRight_GridProbabilisticDistribution gpd4 = new LeftRight_GridProbabilisticDistribution("GPD_Table3D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Mot-a^t");
        params.put("knownNames", "cst_mod");
        params.put("paramNames", "@mot-a_{(x, y)}^t:0#@(x, y):0#@(x, y):1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd4.init(params);
        LeftRight_GridProbabilisticDistribution gpd5 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
        params = new Hashtable();
        params.put("knownNames", "Mot-c^t");
        params.put("searchNames", "i-o_{(x, y)}^t");
        params.put("functionType", "BetaDistributionFunction1D");
        params.put("functionParameters", "");
        params.put("functionVariableNames", "@(x, y)#@Mot-c^t#@i-o_{(x, y)}^t");
        gpd5.init(params);
        LeftRight_GridProbabilisticDistribution gpd6 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Mot-c^t");
        params.put("paramNames", "@Mot-c^t:0#@Mot-c^t:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd6.init(params);
        LeftRight_GridProbabilisticDistribution gpd7 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Mot-c^t");
        params.put("knownNames", "Obs^{0:T}#Mvt^{0:T}");
        params.put("paramNames", "@Mot-c^t:0#@Mot-c^t:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd7.init(params);
        LeftRight_GridProbabilisticDistribution gpd8 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Mot-b^t");
        params.put("knownNames", "Obs^{0:T}#Mvt^{0:T}");
        params.put("paramNames", "@Mot-b^t:0#@Mot-b^t:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd8.init(params);
        LeftRight_GridProbabilisticDistribution gpd9 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
        params = new Hashtable();
        params.put("knownNames", "Mot-b^t");
        params.put("searchNames", "Obj_{(x, y)}^t");
        params.put("functionType", "GridDistanceFunction1D");
        params.put("functionParameters", "1|1|0.01");
        params.put("functionVariableNames", "@(x, y)#@Mot-b^t#@obj_{(x, y)}^t");
        gpd9.init(params);
        LeftRight_GridProbabilisticDistribution gpd10 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
        params = new Hashtable();
        params.put("knownNames", "Mot-b^t");
        params.put("searchNames", "Tgt_{(x, y)}^t");
        params.put("functionType", "GridDistanceFunction1D");
        params.put("functionParameters", "1|1|0.01");
        params.put("functionVariableNames", "@(x, y)#@Mot-b^t#@tgt_{(x, y)}^t");
        gpd10.init(params);
        LeftRight_GridProbabilisticDistribution gpd11 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
        params = new Hashtable();
        params.put("knownNames", "Mot-c^t");
        params.put("searchNames", "i-t_{(x, y)}^t");
        params.put("functionType", "BetaDistributionFunction1D");
        params.put("functionParameters", "");
        params.put("functionVariableNames", "@(x, y)#@Mot-c^t#@i-t_{(x, y)}^t");
        gpd11.init(params);
        FunctionProbabilisticDistribution fpd0 = new FunctionProbabilisticDistribution();
        params = new Hashtable();
        params.put("knownNames", "Obj_{(x, y)}^t");
        params.put("searchNames", "Obs_{(x, y)}^t");
        params.put("functionType", "Matrix2x2Function1D");
        params.put("functionParameters", "0.9,0.9");
        params.put("functionVariableNames", "obs_{(x, y)}^t#obj_{(x, y)}^t");
        fpd0.init(params);
        FunctionProbabilisticDistribution fpd1 = new FunctionProbabilisticDistribution();
        params = new Hashtable();
        params.put("knownNames", "Obj_{Ant}^{t-1}#Mvt^t");
        params.put("searchNames", "Obj_{(x, y)}^t");
        params.put("functionType", "AffectLeakyAntProbaFunction1D");
        params.put("functionParameters", "0.95,0.9");
        params.put("functionVariableNames", "obj_{(x, y)}^t#(x, y)#obj_{ant}^{t-1}");
        fpd1.init(params);
        FunctionProbabilisticDistribution fpd2 = new FunctionProbabilisticDistribution();
        params = new Hashtable();
        params.put("knownNames", "Tgt_{(x, y)}^t");
        params.put("searchNames", "Obj_{(x, y)}^t");
        params.put("functionType", "Matrix2x2Function1D");
        params.put("functionParameters", "0.5,1");
        params.put("functionVariableNames", "obj_{(x, y)}^t#tgt_{(x, y)}^t");
        fpd2.init(params);
        FunctionProbabilisticDistribution fpd3 = new FunctionProbabilisticDistribution();
        params = new Hashtable();
        params.put("knownNames", "Tgt_{Ant}^{t-1}#Mvt^t");
        params.put("searchNames", "Tgt_{(x, y)}^t");
        params.put("functionType", "AffectLeakyAntProbaFunction1D");
        params.put("functionParameters", "1.0,1.0");
        params.put("functionVariableNames", "tgt_{(x, y)}^t#(x, y)#tgt_{ant}^{t-1}");
        fpd3.init(params);
        FunctionProbabilisticDistribution fpd4 = new FunctionProbabilisticDistribution();
        params = new Hashtable();
        params.put("searchNames", "Mot^t");
        params.put("functionType", "GridHistogram1D");
        params.put("functionParameters", this.getConstantModelParams());
        params.put("functionVariableNames", "L-Mot-a^t#R-Mot-a^t");
        fpd4.init(params);
        this.getGridProbaDists().add(gpd0);
        this.getGridProbaDists().add(gpd1);
        this.getGridProbaDists().add(gpd2);
        this.getGridProbaDists().add(gpd3);
        this.getGridProbaDists().add(gpd4);
        this.getGridProbaDists().add(gpd5);
        this.getGridProbaDists().add(gpd6);
        this.getGridProbaDists().add(gpd7);
        this.getGridProbaDists().add(gpd8);
        this.getGridProbaDists().add(gpd9);
        this.getGridProbaDists().add(gpd10);
        this.getGridProbaDists().add(gpd11);
        this.getOthersProbaDists().add(fpd0);
        this.getOthersProbaDists().add(fpd1);
        this.getOthersProbaDists().add(fpd2);
        this.getOthersProbaDists().add(fpd3);
        this.getOthersProbaDists().add(fpd4);
    }

    private String getConstantModelParams() {
        int j;
        int gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.rightGridRefConverter.getPixelHeight();
        double[][] t = new double[gridw][gridh];
        double mh = gridh / 2;
        double mw = gridw - 1;
        int i = 0;
        while (i < gridw) {
            int j2 = 0;
            while (j2 < gridh) {
                t[i][j2] = 1.0 / (10.0 + ((double)i - mw) * ((double)i - mw) + ((double)j2 - mh) * ((double)j2 - mh));
                ++j2;
            }
            ++i;
        }
        double Z = 0.0;
        int i2 = 0;
        while (i2 < gridw) {
            j = 0;
            while (j < gridh) {
                Z += t[i2][j];
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < gridw) {
            j = 0;
            while (j < gridh) {
                t[i2][j] = t[i2][j] / (2.0 * Z);
                ++j;
            }
            ++i2;
        }
        String s = "" + t[0][0];
        j = 1;
        while (j < gridh) {
            s = String.valueOf(s) + "," + t[0][j];
            ++j;
        }
        int i3 = 1;
        while (i3 < gridw) {
            s = String.valueOf(s) + "|" + t[i3][0];
            int j3 = 1;
            while (j3 < gridh) {
                s = String.valueOf(s) + "," + t[i3][j3];
                ++j3;
            }
            ++i3;
        }
        return s;
    }

    protected void initRandomVariables() {
        int gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.rightGridRefConverter.getPixelHeight();
        int[] l_zero_p = Cell.getZeroGridPos(false);
        int[] r_zero_p = Cell.getZeroGridPos(true);
        Object domain = RandomVariable.getDomainForGridPos(gridw, gridh);
        this.setVariable(new LeftRight_Variable(l_zero_p, r_zero_p, "Mvt^t", (int[][])domain));
        this.setVariable(new LeftRight_Variable(l_zero_p, r_zero_p, "Mot-a^t", (int[][])domain));
        this.setVariable(new RandomVariable("(x, y)", (int[][])domain));
        this.setVariable(new RandomVariable("(x', y')", (int[][])domain));
        byte[] byArray = new byte[2];
        byArray[1] = 1;
        byte[] bdomain = byArray;
        this.setVariable(new LeftRight_Variable(gridw, gridh, "Obs^t", bdomain));
        this.setVariable(new LeftRight_Variable(gridw, gridh, "Tgt^0", bdomain));
        int[][] nArrayArray = new int[1][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        domain = nArrayArray;
        this.setVariable(new RandomVariable("obs_{(x, y)}^t", (int[][])domain));
        this.setVariable(new RandomVariable("obj_{(x, y)}^t", (int[][])domain));
        this.setVariable(new RandomVariable("obj_{(x', y')}^{t-1}", (int[][])domain));
        this.setVariable(new RandomVariable("tgt_{(x, y)}^t", (int[][])domain));
        this.setVariable(new RandomVariable("tgt_{(x', y')}^{t-1}", (int[][])domain));
        this.setVariable(new RandomVariable("mot-a_{(x, y)}^t", (int[][])domain));
        this.setVariable(new RandomVariable("mot-b_{(x, y)}^t", (int[][])domain));
        this.setVariable(new RandomVariable("mot-c_{(x, y)}^t", (int[][])domain));
        this.setVariable(new RandomVariable("obj_{ant}^{t-1}", (int[][])domain));
        this.setVariable(new RandomVariable("tgt_{ant}^{t-1}", (int[][])domain));
        bdomain = new byte[Antecedent.getMaxAntecedentsNb() + 1];
        int i = 0;
        while (i < bdomain.length) {
            bdomain[i] = i;
            i = (byte)(i + 1);
        }
        this.setVariable(new LeftRight_Variable(gridw, gridh, "Ant", bdomain));
        this.setVariable(new LeftRight_Variable(gridw, gridh, "CAnt", bdomain));
        double[] rdomain = new double[]{0.0, 1.0};
        this.setVariable(new RandomVariable(0.0, "i-o_{(x, y)}^t", rdomain));
        this.setVariable(new RandomVariable(0.0, "i-t_{(x, y)}^t", rdomain));
        domain = RandomVariable.getDomainForGridPos(gridw, gridh);
        this.setVariable(new RandomVariable("Mot-c^t", (int[][])domain));
        this.setVariable(new RandomVariable("Mot-b^t", (int[][])domain));
    }

    /*
     * Unable to fully structure code
     */
    protected void subInfer() {
        block4: {
            try {
                this.updateVariables();
                this.Q1a_computeInference();
                this.Q1b_computeInference();
                this.Q2a_computeInference();
                this.Q2b_computeInference();
                this.Q2c_computeInference();
                this.notifyUpdate();
            }
            catch (ShowableException se) {
                msg = se.getMessage();
                ** for (crtV : this.getAssociatedViews())
            }
lbl-1000:
            // 1 sources

            {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.MSG_ERR, this, msg, null));
                continue;
lbl16:
                // 1 sources

                break block4;
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "subInfer");
            }
        }
    }

    protected void updateVariables() throws ShowableException {
        Cell sacc_cell = this.updateSaccade();
        if (this.lastSaccadeCell == null || !this.lastSaccadeCell.equals(sacc_cell)) {
            Position sacc_pos = sacc_cell.centerPos;
            Antecedent.setAllAntecedentsFromATranslation(sacc_pos);
            this.lastSaccadeCell = sacc_cell;
            System.out.println("V20_BossEngine::updateVariables -new saccade");
        }
        this.updateObservation();
        this.updateAntecedent(true, "CAnt");
        this.updateAntecedent(false, "Ant");
        this.shiftObjTgt();
        this.notifyUpdate();
    }

    private void shiftObjTgt() {
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        ProbabilisticDistribution[] obj_t = new ProbabilisticDistribution[]{this.getGridProbaDists().get(1).getLeftPart(), this.getGridProbaDists().get(1).getRightPart()};
        ProbabilisticDistribution[] obj_t_1 = new ProbabilisticDistribution[]{this.getGridProbaDists().get(0).getLeftPart(), this.getGridProbaDists().get(0).getRightPart()};
        ProbabilisticDistribution[] tgt_t = new ProbabilisticDistribution[]{this.getGridProbaDists().get(3).getLeftPart(), this.getGridProbaDists().get(3).getRightPart()};
        ProbabilisticDistribution[] tgt_t_1 = new ProbabilisticDistribution[]{this.getGridProbaDists().get(2).getLeftPart(), this.getGridProbaDists().get(2).getRightPart()};
        try {
            int s = 0;
            while (s < 2) {
                int i = 0;
                while (i < gridw) {
                    int j = 0;
                    while (j < gridh) {
                        this.getVariables().get("(x, y)").setList(new int[]{i, j, s});
                        this.getVariables().get("(x', y')").setList(new int[]{i, j, s});
                        int v = 0;
                        while (v < 2) {
                            this.getVariables().get("obj_{(x, y)}^t").setList(new int[]{v});
                            this.getVariables().get("obj_{(x', y')}^{t-1}").setList(new int[]{v});
                            double proba = obj_t[s].getValue(this.getVariables());
                            obj_t_1[s].setNewValue(this.getVariables(), proba);
                            this.getVariables().get("tgt_{(x, y)}^t").setList(new int[]{v});
                            this.getVariables().get("tgt_{(x', y')}^{t-1}").setList(new int[]{v++});
                            proba = tgt_t[s].getValue(this.getVariables());
                            tgt_t_1[s].setNewValue(this.getVariables(), proba);
                        }
                        ++j;
                    }
                    ++i;
                }
                obj_t_1[s].updateValues();
                tgt_t_1[s].updateValues();
                ++s;
            }
        }
        catch (Exception e) {
            Utilities.exceptionCaughtMessage(e, this, "shiftObjTgt");
        }
    }

    private final double Q2c_getLogProdPrior(int x_m, int y_m, int side_m) throws Exception {
        double proba = 0.0;
        double logprod = 0.0;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double proba_occ = 0.0;
        int s = 0;
        while (s < 2) {
            int i = 0;
            while (i < gridw) {
                int j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        proba_occ = 0.00648855;
                        this.getVariable("i-o_{(x, y)}^t").setRealVal(proba_occ);
                        this.getVariable("i-t_{(x, y)}^t").setRealVal(1.0E-5);
                        this.getVariable("(x, y)").setList(new int[]{i, j, s});
                        if (s == 0) {
                            proba = this.getGridProbaDists().get(5).getLeftPart().getValue(this.getVariables());
                            proba *= this.getGridProbaDists().get(11).getLeftPart().getValue(this.getVariables());
                        } else {
                            proba = this.getGridProbaDists().get(5).getRightPart().getValue(this.getVariables());
                            proba *= this.getGridProbaDists().get(11).getRightPart().getValue(this.getVariables());
                        }
                        logprod += StrictMath.log(proba);
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        return logprod;
    }

    private void Q2c_computePrior() throws Exception {
        int j;
        int i;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        this.logPrior_Q2c = new double[2][gridw][gridh];
        double lproba_max = StrictMath.log(0.0);
        double proba_sum = 0.0;
        double[][][] lproba_total = new double[2][gridw][gridh];
        double[][][] proba_total = new double[2][gridw][gridh];
        double lp_mot_prior = 0.0;
        double lp_mot_choix = 0.0;
        int s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        this.getDebugPolicy().traceDebugPreInf(this, new Object[]{i, j, s});
                        this.getVariable("Mot-c^t").setList(new int[]{i, j, s});
                        lp_mot_prior = 0.0;
                        lp_mot_choix = this.Q2c_getLogProdPrior(i, j, s);
                        lproba_total[s][i][j] = lp_mot_prior + lp_mot_choix;
                        lproba_max = StrictMath.max(lproba_max, lproba_total[s][i][j]);
                    } else {
                        lproba_total[s][i][j] = StrictMath.log(0.0);
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    proba_total[s][i][j] = StrictMath.exp(lproba_total[s][i][j] - lproba_max);
                    proba_sum += proba_total[s][i][j];
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.logPrior_Q2c[s][i][j] = proba_total[s][i][j] == 0.0 ? StrictMath.log(0.0) : -StrictMath.log(proba_total[s][i][j] / proba_sum);
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        this.priorQ2c_ok = true;
    }

    private void Q2c_computeInference() throws Exception {
        int j;
        int i;
        if (!this.priorQ2c_ok) {
            this.Q2c_computePrior();
        }
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double lproba_max = StrictMath.log(0.0);
        double proba_sum = 0.0;
        double[][][] lproba_total = new double[2][gridw][gridh];
        double[][][] proba_total = new double[2][gridw][gridh];
        double lp_mot_prior = 0.0;
        double lp_mot_choix = 0.0;
        int s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.getVariable("Mot-c^t").setList(new int[]{i, j, s});
                    lp_mot_prior = this.logPrior_Q2c[s][i][j];
                    lp_mot_choix = this.Q2c_getLogProd(i, j, s);
                    lproba_total[s][i][j] = lp_mot_prior + lp_mot_choix;
                    lproba_max = StrictMath.max(lproba_max, lproba_total[s][i][j]);
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    proba_total[s][i][j] = StrictMath.exp(lproba_total[s][i][j] - lproba_max);
                    proba_sum += proba_total[s][i][j];
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.getVariable("Mot-c^t").setList(new int[]{i, j, s});
                    if (s == 0) {
                        this.getGridProbaDists().get(7).getLeftPart().setNewValue(this.getVariables(), proba_total[s][i][j] / proba_sum);
                    } else {
                        this.getGridProbaDists().get(7).getRightPart().setNewValue(this.getVariables(), proba_total[s][i][j] / proba_sum);
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        this.getGridProbaDists().get(7).getLeftPart().updateValues();
        this.getGridProbaDists().get(7).getRightPart().updateValues();
        BetaDistributionFunction1D.printStats();
    }

    private final double Q2c_getLogProd(int x_m, int y_m, int side_m) throws Exception {
        double proba = 0.0;
        double logprod = 0.0;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double proba_obj = 0.0;
        double proba_tgt = 0.0;
        int s = 0;
        while (s < 2) {
            int i = 0;
            while (i < gridw) {
                int j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        this.getVariable("obj_{(x, y)}^t").setList(new int[]{1});
                        this.getVariable("tgt_{(x, y)}^t").setList(new int[]{1});
                        this.getVariable("(x, y)").setList(new int[]{i, j, s});
                        if (s == 0) {
                            proba_obj = this.getGridProbaDists().get(1).getLeftPart().getValue(this.getVariables());
                            proba_tgt = this.getGridProbaDists().get(3).getLeftPart().getValue(this.getVariables());
                        } else {
                            proba_obj = this.getGridProbaDists().get(1).getRightPart().getValue(this.getVariables());
                            proba_tgt = this.getGridProbaDists().get(3).getRightPart().getValue(this.getVariables());
                        }
                        this.getVariable("i-o_{(x, y)}^t").setRealVal(proba_obj);
                        this.getVariable("i-t_{(x, y)}^t").setRealVal(proba_tgt);
                        if (s == 0) {
                            proba = this.getGridProbaDists().get(5).getLeftPart().getValue(this.getVariables());
                            proba *= this.getGridProbaDists().get(11).getLeftPart().getValue(this.getVariables());
                        } else {
                            proba = this.getGridProbaDists().get(5).getRightPart().getValue(this.getVariables());
                            proba *= this.getGridProbaDists().get(11).getRightPart().getValue(this.getVariables());
                        }
                        logprod += StrictMath.log(proba);
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        return logprod;
    }

    private final double Q2b_getLogProdPrior(int x_m, int y_m, int side_m) throws Exception {
        double proba = 0.0;
        double logprod = 0.0;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        int s = 0;
        while (s < 2) {
            int i = 0;
            while (i < gridw) {
                int j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        this.getVariable("(x, y)").setList(new int[]{i, j, s});
                        this.getVariable("obj_{(x, y)}^t").setList(new int[1]);
                        this.getVariable("tgt_{(x, y)}^t").setList(new int[1]);
                        if (s == 0) {
                            proba = this.getGridProbaDists().get(9).getLeftPart().getValue(this.getVariables());
                            proba *= this.getGridProbaDists().get(10).getLeftPart().getValue(this.getVariables());
                        } else {
                            proba = this.getGridProbaDists().get(9).getRightPart().getValue(this.getVariables());
                            proba *= this.getGridProbaDists().get(10).getRightPart().getValue(this.getVariables());
                        }
                        logprod += StrictMath.log(proba);
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        return logprod;
    }

    private void Q2b_computePrior() throws Exception {
        int j;
        int i;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        this.logPrior_Q2b = new double[2][gridw][gridh];
        double lproba_max = StrictMath.log(0.0);
        double proba_sum = 0.0;
        double[][][] lproba_total = new double[2][gridw][gridh];
        double[][][] proba_total = new double[2][gridw][gridh];
        double lp_mot_prior = 0.0;
        double lp_mot_choix = 0.0;
        int s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        this.getDebugPolicy().traceDebugPreInf(this, new Object[]{i, j, s});
                        this.getVariable("Mot-b^t").setList(new int[]{i, j, s});
                        lp_mot_prior = 0.0;
                        lp_mot_choix = this.Q2b_getLogProdPrior(i, j, s);
                        lproba_total[s][i][j] = lp_mot_prior + lp_mot_choix;
                        lproba_max = StrictMath.max(lproba_max, lproba_total[s][i][j]);
                    } else {
                        lproba_total[s][i][j] = StrictMath.log(0.0);
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    proba_total[s][i][j] = StrictMath.exp(lproba_total[s][i][j] - lproba_max);
                    proba_sum += proba_total[s][i][j];
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.logPrior_Q2b[s][i][j] = proba_total[s][i][j] == 0.0 ? StrictMath.log(0.0) : -StrictMath.log(proba_total[s][i][j] / proba_sum);
                    this.getVariable("Mot-c^t").setList(new int[]{i, j, s});
                    if (s == 0) {
                        this.getGridProbaDists().get(6).getLeftPart().setNewValue(this.getVariables(), proba_total[s][i][j] / proba_sum);
                    } else {
                        this.getGridProbaDists().get(6).getRightPart().setNewValue(this.getVariables(), proba_total[s][i][j] / proba_sum);
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        this.getGridProbaDists().get(6).getLeftPart().updateValues();
        this.getGridProbaDists().get(6).getRightPart().updateValues();
        this.priorQ2b_ok = true;
    }

    private final void Q2b_computeInference() throws Exception {
        int j;
        int i;
        if (!this.priorQ2b_ok) {
            this.Q2b_computePrior();
        }
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double lproba_max = StrictMath.log(0.0);
        double proba_sum = 0.0;
        double[][][] lproba_total = new double[2][gridw][gridh];
        double[][][] proba_total = new double[2][gridw][gridh];
        double lp_mot_prior = 0.0;
        double lp_mot_choix = 0.0;
        int s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.getVariable("Mot-b^t").setList(new int[]{i, j, s});
                    lp_mot_prior = this.logPrior_Q2b[s][i][j];
                    lp_mot_choix = this.Q2b_getLogProd(i, j, s);
                    lproba_total[s][i][j] = lp_mot_prior + lp_mot_choix;
                    lproba_max = StrictMath.max(lproba_max, lproba_total[s][i][j]);
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    proba_total[s][i][j] = StrictMath.exp(lproba_total[s][i][j] - lproba_max);
                    proba_sum += proba_total[s][i][j];
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        System.out.println(lproba_max);
        System.out.println(proba_sum);
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.getVariable("Mot-b^t").setList(new int[]{i, j, s});
                    if (s == 0) {
                        this.getGridProbaDists().get(8).getLeftPart().setNewValue(this.getVariables(), proba_total[s][i][j] / proba_sum);
                    } else {
                        this.getGridProbaDists().get(8).getRightPart().setNewValue(this.getVariables(), proba_total[s][i][j] / proba_sum);
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        this.getGridProbaDists().get(8).getLeftPart().updateValues();
        this.getGridProbaDists().get(8).getRightPart().updateValues();
    }

    private final double Q2b_getLogProd(int x_m, int y_m, int side_m) throws Exception {
        double proba = 0.0;
        double proba_occ = 0.0;
        double proba_tgt = 0.0;
        double logprod = 0.0;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        int s = 0;
        while (s < 2) {
            int i = 0;
            while (i < gridw) {
                int j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        this.getVariable("(x, y)").setList(new int[]{i, j, s});
                        this.getVariable("obj_{(x, y)}^t").setList(new int[]{1});
                        this.getVariable("tgt_{(x, y)}^t").setList(new int[]{1});
                        if (s == 0) {
                            proba_occ = this.getGridProbaDists().get(1).getLeftPart().getValue(this.getVariables());
                            proba_tgt = this.getGridProbaDists().get(3).getLeftPart().getValue(this.getVariables());
                        } else {
                            proba_occ = this.getGridProbaDists().get(1).getRightPart().getValue(this.getVariables());
                            proba_tgt = this.getGridProbaDists().get(3).getRightPart().getValue(this.getVariables());
                        }
                        if (proba_occ < 0.5) {
                            this.getVariable("obj_{(x, y)}^t").setList(new int[1]);
                        } else {
                            System.out.println("(" + i + ", " + j + "): " + s);
                        }
                        if (proba_tgt < 0.5) {
                            this.getVariable("tgt_{(x, y)}^t").setList(new int[1]);
                        } else {
                            System.out.println("(" + i + ", " + j + "): " + s);
                        }
                        if (s == 0) {
                            proba = this.getGridProbaDists().get(9).getLeftPart().getValue(this.getVariables());
                            proba *= this.getGridProbaDists().get(10).getLeftPart().getValue(this.getVariables());
                        } else {
                            proba = this.getGridProbaDists().get(9).getRightPart().getValue(this.getVariables());
                            proba *= this.getGridProbaDists().get(10).getRightPart().getValue(this.getVariables());
                        }
                        logprod += StrictMath.log(proba);
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        return logprod;
    }

    private final void Q2a_computeInference() throws Exception {
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double p = 0.0;
        int s = 0;
        while (s < 2) {
            int i = 0;
            while (i < gridw) {
                int j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        String var_name2;
                        String var_name1;
                        if (s == 1) {
                            var_name1 = "R-Mot-a^t";
                            var_name2 = "L-Mot-a^t";
                        } else {
                            var_name1 = "L-Mot-a^t";
                            var_name2 = "R-Mot-a^t";
                        }
                        try {
                            this.getVariable(var_name1).setList(new int[]{i, j});
                            this.getVariable(var_name2).setToDefaultValues();
                            this.getVariable("(x, y)").setList(new int[]{i, j, s});
                        }
                        catch (Exception e) {
                            Utilities.exceptionCaughtMessage(e, this, "Q2a_computeInference");
                        }
                        p = this.getOthersProbaDists().get(4).getValue(this.getVariables());
                    } else {
                        p = 0.0;
                    }
                    this.getVariable("(x, y)").setList(new int[]{i, j, s});
                    double[] dist = new double[]{1.0 - p, p};
                    int k = 0;
                    while (k < 2) {
                        this.getVariable("mot-a_{(x, y)}^t").setList(new int[]{k});
                        if (s == 0) {
                            this.getGridProbaDists().get(4).getLeftPart().setNewValue(this.getVariables(), dist[k]);
                        } else {
                            this.getGridProbaDists().get(4).getRightPart().setNewValue(this.getVariables(), dist[k]);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        this.getGridProbaDists().get(4).getLeftPart().updateValues();
        this.getGridProbaDists().get(4).getRightPart().updateValues();
        this.notifyUpdate();
    }

    private final void Q1b_computeInference() throws Exception {
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        int[][] var_domain = this.getVariable("tgt_{(x, y)}^t").getListDomain();
        double proba_total = 0.0;
        Object proba_prod = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
        double[] proba_fin = new double[]{0.0, 0.0};
        double proba_obj = 1.0;
        int s = 0;
        while (s < 2) {
            int i = 0;
            while (i < gridw) {
                int j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        double proba_vois = 0.0;
                        double proba_capt = 0.0;
                        proba_prod = new double[2][2];
                        this.getVariable("(x, y)").setList(new int[]{i, j, s});
                        int v = 0;
                        while (v < 2) {
                            this.getVariable("obj_{(x, y)}^t").setListVar(0, v);
                            proba_obj = s == 1 ? this.getGridProbaDists().get(1).getRightPart().getValue(this.getVariables()) : this.getGridProbaDists().get(1).getLeftPart().getValue(this.getVariables());
                            int k = 0;
                            while (k < var_domain[0].length) {
                                this.getVariable("tgt_{(x, y)}^t").setListVar(0, var_domain[0][k]);
                                proba_vois = this.Q1_getSum(i, j, s, "tgt", 2, 3);
                                proba_capt = this.getOthersProbaDists().get(2).getValue(this.getVariables());
                                proba_prod[k][v] = proba_capt * proba_vois;
                                ++k;
                            }
                            proba_total = proba_prod[0][v] + proba_prod[1][v];
                            proba_prod[0][v] = proba_obj * proba_prod[0][v] / proba_total;
                            proba_prod[1][v] = proba_obj * proba_prod[1][v] / proba_total;
                            ++v;
                        }
                        proba_fin[0] = proba_prod[0][0] + proba_prod[0][1];
                        proba_fin[1] = proba_prod[1][0] + proba_prod[1][1];
                    } else {
                        proba_fin = new double[]{1.0, 0.0};
                    }
                    int k = 0;
                    while (k < var_domain[0].length) {
                        int var_val = var_domain[0][k];
                        this.getVariable("tgt_{(x, y)}^t").setList(new int[]{var_val});
                        this.getVariable("(x, y)").setList(new int[]{i, j, s});
                        if (s == 0) {
                            this.getGridProbaDists().get(3).getLeftPart().setNewValue(this.getVariables(), proba_fin[k]);
                        } else {
                            this.getGridProbaDists().get(3).getRightPart().setNewValue(this.getVariables(), proba_fin[k]);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        this.getGridProbaDists().get(3).getLeftPart().updateValues();
        this.getGridProbaDists().get(3).getRightPart().updateValues();
    }

    private final void Q1a_computeInference() throws Exception {
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        int[][] var_domain = this.getVariable("obj_{(x, y)}^t").getListDomain();
        double proba_total = 0.0;
        int s = 0;
        while (s < 2) {
            byte[][] obs_val = s == 0 ? this.getVariable("L-Obs^t").getTable() : this.getVariable("R-Obs^t").getTable();
            int i = 0;
            while (i < gridw) {
                int j = 0;
                while (j < gridh) {
                    int k;
                    double[] proba_prod;
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        proba_total = 0.0;
                        double[] proba_vois = new double[var_domain[0].length];
                        double[] proba_capt = new double[var_domain[0].length];
                        proba_prod = new double[var_domain[0].length];
                        this.getVariable("obs_{(x, y)}^t").setListVar(0, obs_val[i][j]);
                        k = 0;
                        while (k < var_domain[0].length) {
                            this.getVariable("obj_{(x, y)}^t").setListVar(0, var_domain[0][k]);
                            this.getVariable("(x, y)").setList(new int[]{i, j, s});
                            proba_vois[k] = this.Q1_getSum(i, j, s, "obj", 0, 1);
                            proba_capt[k] = this.getOthersProbaDists().get(0).getValue(this.getVariables());
                            proba_prod[k] = proba_capt[k] * proba_vois[k];
                            proba_total += proba_prod[k];
                            ++k;
                        }
                    } else {
                        proba_prod = new double[]{1.0, 0.0};
                        proba_total = 1.0;
                    }
                    k = 0;
                    while (k < var_domain[0].length) {
                        int var_val = var_domain[0][k];
                        this.getVariable("obj_{(x, y)}^t").setList(new int[]{var_val});
                        this.getVariable("(x, y)").setList(new int[]{i, j, s});
                        if (s == 0) {
                            this.getGridProbaDists().get(1).getLeftPart().setNewValue(this.getVariables(), proba_prod[k] / proba_total);
                        } else {
                            this.getGridProbaDists().get(1).getRightPart().setNewValue(this.getVariables(), proba_prod[k] / proba_total);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        this.getGridProbaDists().get(1).getLeftPart().updateValues();
        this.getGridProbaDists().get(1).getRightPart().updateValues();
    }

    private final double Q1_getSum(int x, int y, int side, String varname, int dist_t_1, int dist_dyn) throws Exception {
        Cell[] ant_cells = Antecedent.getCells(x, y, side);
        int[] val_ants = new int[ant_cells.length];
        int max_powa = (int)StrictMath.rint(StrictMath.pow(2.0, ant_cells.length));
        int[] two_p = new int[ant_cells.length];
        int k = 0;
        while (k < two_p.length) {
            two_p[k] = (int)StrictMath.rint(StrictMath.pow(2.0, k));
            ++k;
        }
        double proba_sum = 0.0;
        if (val_ants.length != 0) {
            int[][] domain = new int[val_ants.length][2];
            int i = 0;
            while (i < domain.length) {
                int[] nArray = new int[2];
                nArray[1] = 1;
                domain[i] = nArray;
                ++i;
            }
            this.setVariable(new RandomVariable(String.valueOf(varname) + "_{ant}^{t-1}", domain));
            int[] cpts = new int[ant_cells.length];
            int[] values = new int[ant_cells.length];
            double proba1 = 0.0;
            double proba2 = 0.0;
            int k2 = 0;
            while (k2 < max_powa) {
                int i2 = 0;
                while (i2 < ant_cells.length) {
                    val_ants[i2] = values[i2];
                    int n = i2;
                    cpts[n] = cpts[n] + 1;
                    if (cpts[i2] % two_p[i2] == 0) {
                        values[i2] = (values[i2] + 1) % 2;
                    }
                    ++i2;
                }
                this.getVariable(String.valueOf(varname) + "_{ant}^{t-1}").setList(val_ants);
                proba1 = this.getOthersProbaDists().get(dist_dyn).getValue(this.getVariables());
                proba2 = this.Q1_getSum_getOldQ1(ant_cells, val_ants, varname, dist_t_1);
                proba_sum += proba1 * proba2;
                ++k2;
            }
        } else {
            proba_sum = side == 1 ? this.getGridProbaDists().get(dist_t_1).getRightPart().getValue(this.getVariables()) : this.getGridProbaDists().get(dist_t_1).getRightPart().getValue(this.getVariables());
        }
        return proba_sum;
    }

    private final double Q1_getSum_getOldQ1(Cell[] antCells, int[] antVals, String varname, int dist) throws Exception {
        double retour = 1.0;
        double proba = 0.0;
        int[] ant_cell_pos = null;
        GridProbabilisticDistribution gpd = null;
        int i = 0;
        while (i < antCells.length) {
            ant_cell_pos = new int[]{antCells[i].x, antCells[i].y};
            this.getVariable("(x', y')").setList(ant_cell_pos);
            this.getVariable(String.valueOf(varname) + "_{(x', y')}^{t-1}").setList(new int[]{antVals[i]});
            gpd = antCells[i].isRight ? this.getGridProbaDists().get(dist).getRightPart() : this.getGridProbaDists().get(dist).getLeftPart();
            proba = gpd.getValue(this.getVariables());
            retour *= proba;
            ++i;
        }
        return retour;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Cell updateSaccade() throws ShowableException {
        if (this.getSaccades().size() < 1) {
            String msg = String.valueOf(this.getClass().getName()) + "::updateSaccade" + " -error";
            System.out.println(String.valueOf(msg) + " not enough saccades");
            msg = "Problem in the data update$Update of the saccades data is not possible :\nnot enough saccades !";
            throw new ShowableException(msg);
        }
        String var_name1 = "";
        String var_name2 = "";
        Cell sacc_cell = Cell.getCell(this.getSaccades().get((int)0).position);
        if (sacc_cell == null) {
            System.out.println(String.valueOf(this.getClass().getName()) + "::updateSaccade" + " infos saccade pos outside the grid (" + sacc_cell.x + "," + sacc_cell.y + "), Sacc^t not updated");
            return null;
        }
        if (sacc_cell.isRight) {
            var_name1 = "R-Mvt^t";
            var_name2 = "L-Mvt^t";
        } else {
            var_name1 = "L-Mvt^t";
            var_name2 = "R-Mvt^t";
        }
        try {
            this.getVariable(var_name1).setListVar(0, sacc_cell.x);
            this.getVariable(var_name1).setListVar(1, sacc_cell.y);
            this.getVariable(var_name2).setToDefaultValues();
            return sacc_cell;
        }
        catch (Exception e) {
            Utilities.exceptionCaughtMessage(e, this, "updateSaccade");
            return null;
        }
    }

    private final void updateObservation() throws ShowableException {
        int l_gridw = Cell.leftGridRefConverter.getPixelWidth();
        int r_gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        byte[][] l_obs = new byte[l_gridw][gridh];
        byte[][] r_obs = new byte[r_gridw][gridh];
        for (Observation observation : this.getObservations()) {
            this.fillObservation(observation, l_obs, r_obs);
        }
        for (Target target : this.getTargets()) {
            this.fillObservation(target, l_obs, r_obs);
        }
        try {
            this.getVariable("R-Obs^t").setTable(r_obs);
            this.getVariable("L-Obs^t").setTable(l_obs);
        }
        catch (Exception exception) {
            Utilities.exceptionCaughtMessage(exception, this, "updateObservation");
        }
    }

    private final void updateAntecedent(boolean colored, String varName) throws ShowableException {
        int val;
        int[] nums;
        Cell[] crt_ants;
        Cell crt_cell;
        int l_gridw = Cell.leftGridRefConverter.getPixelWidth();
        int r_gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        byte[][] l_ant = new byte[l_gridw][gridh];
        byte[][] r_ant = new byte[r_gridw][gridh];
        if (this.getObservations() != null && this.getObservations().size() > 0) {
            for (Observation observation : this.getObservations()) {
                crt_cell = Cell.getCell(observation.position);
                if (crt_cell == null) continue;
                crt_ants = Antecedent.getCells(crt_cell);
                nums = Antecedent.getNumerosity(crt_cell);
                int i = 0;
                while (i < crt_ants.length) {
                    val = 10;
                    if (colored) {
                        val = (byte)nums[i];
                    }
                    if (crt_ants[i].isRight) {
                        r_ant[crt_ants[i].x][crt_ants[i].y] = val;
                    } else {
                        l_ant[crt_ants[i].x][crt_ants[i].y] = val;
                    }
                    ++i;
                }
                try {
                    this.getVariable("R-" + varName).setTable(r_ant);
                    this.getVariable("L-" + varName).setTable(l_ant);
                }
                catch (Exception e) {
                    Utilities.exceptionCaughtMessage(e, this, "updateAnt");
                }
            }
        }
        if (this.getTargets() != null && this.getTargets().size() > 0) {
            for (Observation observation : this.getTargets()) {
                crt_cell = Cell.getCell(observation.position);
                if (crt_cell == null) continue;
                crt_ants = Antecedent.getCells(crt_cell);
                nums = Antecedent.getNumerosity(crt_cell);
                int i = 0;
                while (i < crt_ants.length) {
                    val = 10;
                    if (colored) {
                        val = (byte)nums[i];
                    }
                    if (crt_ants[i].isRight) {
                        r_ant[crt_ants[i].x][crt_ants[i].y] = val;
                    } else {
                        l_ant[crt_ants[i].x][crt_ants[i].y] = val;
                    }
                    ++i;
                }
                try {
                    this.getVariable("R-" + varName).setTable(r_ant);
                    this.getVariable("L-" + varName).setTable(l_ant);
                }
                catch (Exception e) {
                    Utilities.exceptionCaughtMessage(e, this, "updateAnt");
                }
            }
        }
    }

    private final void fillObservation(Observation crtT, byte[][] l_obs, byte[][] r_obs) {
        double sq_radius = StrictMath.pow(crtT.size / 2.0, 2.0);
        double h_c = crtT.position.getX1();
        double v_c = crtT.position.getY1();
        GridReferenceConverter l_grc = Cell.leftGridRefConverter;
        GridReferenceConverter r_grc = Cell.rightGridRefConverter;
        int gridw = l_grc.getPixelWidth();
        int gridh = l_grc.getPixelHeight();
        int i = 0;
        while (i < gridw) {
            int j = 0;
            while (j < gridh) {
                Position l_pos = new Position(l_grc.xBasic(i), l_grc.yBasic(j), false);
                Position r_pos = new Position(r_grc.xBasic(i), r_grc.yBasic(j), false);
                if (Cell.gridCells[0][i][j].isInsideTheGrid && sq_radius >= StrictMath.pow(l_pos.getX1() - h_c, 2.0) + StrictMath.pow(l_pos.getY1() - v_c, 2.0)) {
                    l_obs[i][j] = 1;
                }
                if (Cell.gridCells[1][i][j].isInsideTheGrid && sq_radius >= StrictMath.pow(r_pos.getX1() - h_c, 2.0) + StrictMath.pow(r_pos.getY1() - v_c, 2.0)) {
                    r_obs[i][j] = 1;
                }
                ++j;
            }
            ++i;
        }
        Cell t_cell = Cell.getCell(crtT.position);
        if (t_cell.isRight) {
            r_obs[t_cell.x][t_cell.y] = 1;
        } else {
            l_obs[t_cell.x][t_cell.y] = 1;
        }
    }

    protected void flash() {
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        byte[][] l_tgt = new byte[gridw][gridh];
        byte[][] r_tgt = new byte[gridw][gridh];
        for (Target t : this.getTargets()) {
            this.fillObservation(t, l_tgt, r_tgt);
        }
        try {
            this.updateObservation();
            this.getVariable("R-Tgt^0").setTable(r_tgt);
            this.getVariable("L-Tgt^0").setTable(l_tgt);
            int i = 0;
            while (i < gridw) {
                int j = 0;
                while (j < gridh) {
                    this.getVariable("tgt_{(x, y)}^t").setListVar(0, 0);
                    int[] nArray = new int[3];
                    nArray[0] = i;
                    nArray[1] = j;
                    this.getVariable("(x, y)").setList(nArray);
                    this.getGridProbaDists().get(3).getLeftPart().setNewValue(this.getVariables(), 0.99999 - 0.99998 * (double)l_tgt[i][j]);
                    this.getVariable("(x, y)").setList(new int[]{i, j, 1});
                    this.getGridProbaDists().get(3).getRightPart().setNewValue(this.getVariables(), 0.99999 - 0.99998 * (double)r_tgt[i][j]);
                    this.getVariable("tgt_{(x, y)}^t").setListVar(0, 1);
                    this.getGridProbaDists().get(3).getRightPart().setNewValue(this.getVariables(), 1.0E-5 + 0.99998 * (double)r_tgt[i][j]);
                    int[] nArray2 = new int[3];
                    nArray2[0] = i;
                    nArray2[1] = j;
                    this.getVariable("(x, y)").setList(nArray2);
                    this.getGridProbaDists().get(3).getLeftPart().setNewValue(this.getVariables(), 1.0E-5 + 0.99998 * (double)l_tgt[i][j]);
                    ++j;
                }
                ++i;
            }
            this.getGridProbaDists().get(3).getLeftPart().updateValues();
            this.getGridProbaDists().get(3).getRightPart().updateValues();
            byte[][] l_obj = this.getVariable("L-Obs^t").getTable();
            byte[][] r_obj = this.getVariable("R-Obs^t").getTable();
            int i2 = 0;
            while (i2 < gridw) {
                int j = 0;
                while (j < gridh) {
                    this.getVariable("obj_{(x, y)}^t").setListVar(0, 0);
                    int[] nArray = new int[3];
                    nArray[0] = i2;
                    nArray[1] = j;
                    this.getVariable("(x, y)").setList(nArray);
                    this.getGridProbaDists().get(1).getLeftPart().setNewValue(this.getVariables(), 0.99999 - 0.99998 * (double)l_obj[i2][j]);
                    this.getVariable("(x, y)").setList(new int[]{i2, j, 1});
                    this.getGridProbaDists().get(1).getRightPart().setNewValue(this.getVariables(), 0.99999 - 0.99998 * (double)r_obj[i2][j]);
                    this.getVariable("obj_{(x, y)}^t").setListVar(0, 1);
                    this.getGridProbaDists().get(1).getRightPart().setNewValue(this.getVariables(), 1.0E-5 + 0.99998 * (double)r_obj[i2][j]);
                    int[] nArray3 = new int[3];
                    nArray3[0] = i2;
                    nArray3[1] = j;
                    this.getVariable("(x, y)").setList(nArray3);
                    this.getGridProbaDists().get(1).getLeftPart().setNewValue(this.getVariables(), 1.0E-5 + 0.99998 * (double)l_obj[i2][j]);
                    ++j;
                }
                ++i2;
            }
            this.getGridProbaDists().get(1).getLeftPart().updateValues();
            this.getGridProbaDists().get(1).getRightPart().updateValues();
        }
        catch (Exception e) {
            Utilities.exceptionCaughtMessage(e, this, "flash");
        }
        this.notifyUpdate();
    }

    protected Position decideSaccade() {
        throw new Error("Unresolved compilation problem: \n\tThe method decideSaccade() of type V20_BossEngine must override a superclass method\n");
    }

    protected Position decideSaccade(int n) {
        throw new Error("Unresolved compilation problem: \n\tThe type V20_BossEngine must implement the inherited abstract method BossEngine.decideSaccade(int)\n");
    }

    protected int[] solveTask() {
        throw new Error("Unresolved compilation problem: \n\tThe type V20_BossEngine must implement the inherited abstract method BossEngine.solveTask()\n");
    }
}

