/*
 * Decompiled with CFR 0.152.
 */
package engine;

import java.awt.Dimension;
import utils.Utilities;

public class RandomVariable {
    private RVType myType;
    private String myName;
    private double[] myRealDomain;
    private int[][] myListDomain;
    private byte[] myTableDomain;
    private double myDefaultRealVal;
    private int[] myDefaultList;
    private byte[][] myDefaultTable;
    private double myRealVal;
    private int[] myList;
    private byte[][] myTable;

    public final double getRealVal() {
        return this.myRealVal;
    }

    public final void setRealVal(double myRV) {
        this.myRealVal = myRV;
    }

    private final double getDefaultRealVal() {
        return this.myDefaultRealVal;
    }

    private final void setDefaultRealVal(double myDRV) {
        this.myDefaultRealVal = myDRV;
    }

    private final double[] getRealDomain() {
        return this.myRealDomain;
    }

    private final void setRealDomain(double[] myRD) {
        this.myRealDomain = myRD;
    }

    public final byte[] getTableDomain() {
        return this.myTableDomain;
    }

    private final void setTableDomain(byte[] tableDomain) {
        this.myTableDomain = tableDomain;
    }

    public final int[][] getListDomain() {
        return this.myListDomain;
    }

    private final void setListDomain(int[][] listDomain) {
        this.myListDomain = (int[][])(listDomain != null ? Utilities.tabClone(listDomain) : null);
    }

    private final RVType getType() {
        return this.myType;
    }

    private final void setType(RVType type) {
        this.myType = type;
    }

    private final int[] getDefaultList() {
        return this.myDefaultList;
    }

    private final void setDefaultList(int[] defaultList) {
        this.myDefaultList = defaultList;
    }

    private final byte[][] getDefaultTable() {
        return this.myDefaultTable;
    }

    private final void setDefaultTable(byte[][] defaultTable) {
        this.myDefaultTable = defaultTable;
    }

    public final String getName() {
        return this.myName;
    }

    private final void setName(String name) {
        this.myName = name;
    }

    public final int getListVar(int index) {
        if (index > this.myList.length - 1) {
            System.out.println("RandomVariable::getListVar -error: [" + this.getName() + "] variable" + " has only " + this.myList.length + " variable values (can't get the " + index + "th)\n" + this);
            Exception e = new Exception();
            e.printStackTrace();
            System.exit(1);
            return 0;
        }
        return this.myList[index];
    }

    public final int[] getList() {
        return this.myList;
    }

    public final Dimension getVariableDim() {
        switch (this.getType()) {
            case INT_LIST: {
                return new Dimension(1, this.myList.length);
            }
            case BYTE_TABLE: {
                return new Dimension(this.myTable.length, this.myTable[0].length);
            }
            case REAL_VAL: {
                return new Dimension(1, 1);
            }
        }
        return null;
    }

    public final void setList(int[] varList) {
        this.myList = varList;
    }

    public final void setListVar(int index, int varValue) {
        this.myList[index] = varValue;
    }

    public final byte[][] getTable() {
        return this.myTable;
    }

    public final void setTable(byte[][] valuesTable) {
        this.myTable = valuesTable;
    }

    public final void setTableVar(int x, int y, byte varVal) {
        this.myTable[x][y] = varVal;
    }

    public final void setTableVar(int x, int y, double varVal, double min, double max) {
        double domain_size = this.getTableDomain().length - 2;
        int index = (int)StrictMath.rint((varVal - min) / (max - min) * domain_size) + 1;
        this.myTable[x][y] = this.getTableDomain()[index];
    }

    public RandomVariable(String name) {
        this.setName(name);
        this.setType(RVType.INT_LIST);
        this.setList(null);
        this.setDefaultList(null);
        this.setListDomain(null);
    }

    public RandomVariable(String name, int[][] domain) {
        this.setName(name);
        this.setType(RVType.INT_LIST);
        int[] list = new int[domain.length];
        int i = 0;
        while (i < list.length) {
            list[i] = domain[i][0];
            ++i;
        }
        this.setList(list);
        this.setDefaultList(list);
        this.setListDomain(domain);
    }

    public RandomVariable(int[] list, String name, int[][] domain) {
        this.setName(name);
        this.setType(RVType.INT_LIST);
        this.setList(Utilities.tabClone(list));
        this.setDefaultList(Utilities.tabClone(list));
        this.setListDomain(domain);
    }

    public RandomVariable(int nbColumns, int nbRows, String name, byte[] domain) {
        this.setName(name);
        this.setType(RVType.BYTE_TABLE);
        byte[][] values1 = new byte[nbColumns][nbRows];
        byte[][] values2 = new byte[nbColumns][nbRows];
        this.setTable(values2);
        this.setDefaultTable(values1);
        this.setTableDomain(domain);
    }

    public RandomVariable(byte[][] table, String name, byte[] domain) {
        this.setName(name);
        this.setType(RVType.BYTE_TABLE);
        this.setTable(Utilities.tabClone(table));
        this.setDefaultTable(Utilities.tabClone(table));
        this.setTableDomain(domain);
    }

    public RandomVariable(double realVal, String name, double[] domain) {
        this.setName(name);
        this.setType(RVType.BYTE_TABLE);
        this.setRealVal(realVal);
        this.setDefaultRealVal(realVal);
        this.setRealDomain(domain);
    }

    public final void setToDefaultValues() {
        switch (this.getType()) {
            case INT_LIST: {
                this.setList(Utilities.tabClone(this.getDefaultList()));
                break;
            }
            case BYTE_TABLE: {
                this.setTable(Utilities.tabClone(this.getDefaultTable()));
                break;
            }
            case REAL_VAL: {
                this.setRealVal(this.getDefaultRealVal());
            }
        }
    }

    public final double[][] getValuesTableAsDouble(int nbColumns, int nbLines) {
        switch (this.getType()) {
            case REAL_VAL: {
                String msg = String.valueOf(this.getClass().getName()) + "::getValuesTableAsDouble" + " -error: real value cannot be returned as a double table";
                System.out.println(msg);
                System.exit(1);
            }
            case INT_LIST: {
                String msg;
                if (this.getList().length != 2) {
                    msg = String.valueOf(this.getClass().getName()) + "::getValuesTableAsDouble" + " -error:" + this.getName() + " variable, bad dimensions (" + this.getList().length + " instead of 2, for a table";
                    System.out.println(msg);
                    System.exit(1);
                } else {
                    double[][] retour = new double[nbColumns][nbLines];
                    if (this.getListVar(0) >= 0 && this.getListVar(1) >= 0) {
                        int i = 0;
                        while (i < retour.length) {
                            int j = 0;
                            while (j < retour[i].length) {
                                if (i == this.getListVar(0) && j == this.getListVar(1)) {
                                    retour[i][j] = 1.0;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    return retour;
                }
            }
            case BYTE_TABLE: {
                int tablew = this.getTable().length;
                int tableh = this.getTable()[0].length;
                if (tablew != nbColumns || tableh != nbLines) {
                    String msg = String.valueOf(this.getClass().getName()) + "::getValuesTableAsDouble" + " -error:" + this.getName() + " variable, bad dimensions (" + tablew + "," + tableh + ") instead of (" + nbColumns + "," + nbLines + ") requested";
                    System.out.println(msg);
                    System.exit(1);
                    break;
                }
                byte min_val = 127;
                byte max_val = -128;
                int i = 0;
                while (i < this.getTableDomain().length) {
                    if (this.getTableDomain()[i] > max_val) {
                        max_val = this.getTableDomain()[i];
                    }
                    if (this.getTableDomain()[i] < min_val) {
                        min_val = this.getTableDomain()[i];
                    }
                    ++i;
                }
                double[][] retour = new double[tablew][tableh];
                if (max_val - min_val != 0) {
                    double coef = 1.0 / (double)(max_val - min_val);
                    int i2 = 0;
                    while (i2 < retour.length) {
                        int j = 0;
                        while (j < retour[i2].length) {
                            retour[i2][j] = coef * (double)(this.getTable()[i2][j] - max_val) + 1.0;
                            ++j;
                        }
                        ++i2;
                    }
                } else {
                    String msg = String.valueOf(this.getClass().getName()) + "::getValuesTableAsDouble" + " -error:" + this.getName() + " variable, bad domain reduce to 0";
                    System.out.println(msg);
                    System.exit(1);
                }
                return retour;
            }
        }
        return null;
    }

    public final String toString() {
        String s = "<RandomVariable name=" + this.getName();
        s = String.valueOf(s) + " type=" + (Object)((Object)this.getType()) + ">\n\t<values>";
        switch (this.getType()) {
            case INT_LIST: {
                int i = 0;
                while (i < this.getList().length) {
                    s = String.valueOf(s) + this.getListVar(i);
                    if (i != this.getList().length - 1) {
                        s = String.valueOf(s) + ",";
                    }
                    ++i;
                }
                s = String.valueOf(s) + "</values>\n\t<domain>";
                i = 0;
                while (i < this.getListDomain().length) {
                    s = String.valueOf(s) + "\n\t\t" + i + "th var {";
                    int j = 0;
                    while (j < this.getListDomain()[i].length) {
                        s = String.valueOf(s) + this.getListDomain()[i][j];
                        if (j != this.getListDomain()[i].length - 1) {
                            s = String.valueOf(s) + ",";
                        }
                        ++j;
                    }
                    s = String.valueOf(s) + "}";
                    ++i;
                }
                s = String.valueOf(s) + "\n\t";
                break;
            }
            case BYTE_TABLE: {
                s = String.valueOf(s) + "\n  ";
                int i = 0;
                while (i < this.getTable().length) {
                    int j = 0;
                    while (j < this.getTable()[i].length) {
                        s = String.valueOf(s) + this.getTable()[i][j];
                        if (j != this.getTable()[i].length - 1) {
                            s = String.valueOf(s) + ",";
                        }
                        ++j;
                    }
                    s = String.valueOf(s) + "\n  ";
                    ++i;
                }
                s = String.valueOf(s) + "</values> <domain each var>";
                i = 0;
                while (i < this.getTableDomain().length) {
                    s = String.valueOf(s) + this.getTableDomain()[i];
                    if (i != this.getTableDomain().length - 1) {
                        s = String.valueOf(s) + ",";
                    }
                    ++i;
                }
                break;
            }
            case REAL_VAL: {
                s = String.valueOf(s) + this.getRealVal();
                s = String.valueOf(s) + "</values> <domain each var>";
                int i = 0;
                while (i < this.getRealDomain().length) {
                    s = String.valueOf(s) + this.getRealDomain()[i];
                    if (i != this.getRealDomain().length - 1) {
                        s = String.valueOf(s) + ",";
                    }
                    ++i;
                }
                break;
            }
        }
        s = String.valueOf(s) + "<domain>\n</RandomVariable>";
        return s;
    }

    public static final int[][] getDomainForGridPos(int gridw, int gridh) {
        int[][] domain = new int[][]{new int[gridw], new int[gridh]};
        int i = 0;
        while (i < domain[0].length) {
            domain[0][i] = i;
            ++i;
        }
        i = 0;
        while (i < domain[1].length) {
            domain[1][i] = i;
            ++i;
        }
        return domain;
    }

    public RandomVariable(RandomVariable v) {
        this.setType(v.getType());
        this.setName(v.getName());
        switch (v.getType()) {
            case INT_LIST: {
                this.setListDomain(v.getListDomain());
                this.setDefaultList(v.getDefaultList());
                if (v.getList() == null) break;
                this.setList((int[])v.getList().clone());
                break;
            }
            case BYTE_TABLE: {
                this.setTableDomain(v.getTableDomain());
                this.setDefaultTable(v.getDefaultTable());
                if (v.getTable() == null) break;
                this.setTable((byte[][])v.getTable().clone());
                break;
            }
            case REAL_VAL: {
                this.setRealDomain(v.getRealDomain());
                this.setDefaultRealVal(v.getDefaultRealVal());
                this.setRealVal(v.getRealVal());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RVType {
        INT_LIST,
        BYTE_TABLE,
        ANT_LIST,
        REAL_VAL;

    }
}

