/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.RandomVariable;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProbabilisticDistribution {
    private int[] myParamIndex;
    private String[] myParamNames;
    private String myInferenceName;
    private String[] mySearchVarNames;
    private String[] myKnownVarNames;
    private Hashtable<String, String> myparams;

    private final int[] getParamIndex() {
        return this.myParamIndex;
    }

    protected final int getParamIndex(int rank) {
        return this.myParamIndex[rank];
    }

    private final void setParamIndex(int[] paramIndex) {
        this.myParamIndex = paramIndex;
    }

    private final String[] getParamNames() {
        return this.myParamNames;
    }

    protected final String getParamName(int index) {
        return this.myParamNames[index];
    }

    private final void setParamNames(String[] paramNames) {
        this.myParamNames = paramNames;
    }

    protected final String getInferenceName() {
        return this.myInferenceName;
    }

    private final void setInferenceName(String inferenceName) {
        this.myInferenceName = inferenceName;
    }

    protected final String[] getKnownVarNames() {
        return this.myKnownVarNames;
    }

    protected final String getKnownVarName(int index) {
        return this.myKnownVarNames[index];
    }

    private final void setKnownVarNames(String[] knownVarNames) {
        this.myKnownVarNames = knownVarNames;
    }

    protected final String[] getSearchVarNames() {
        return this.mySearchVarNames;
    }

    protected final String getSearchVarName(int index) {
        return this.mySearchVarNames[index];
    }

    private final void setSearchVarNames(String[] searchVarNames) {
        this.mySearchVarNames = searchVarNames;
    }

    public final String getName() {
        String retour = "";
        if (this.getInferenceName() == null) {
            String name;
            retour = String.valueOf(retour) + "P(";
            String[] stringArray = this.getSearchVarNames();
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                name = stringArray[n];
                retour = String.valueOf(retour) + name;
                ++n;
            }
            if (this.getKnownVarNames() != null) {
                retour = String.valueOf(retour) + "|";
                stringArray = this.getKnownVarNames();
                n = 0;
                n2 = stringArray.length;
                while (n < n2) {
                    name = stringArray[n];
                    retour = String.valueOf(retour) + name;
                    ++n;
                }
            }
            retour = String.valueOf(retour) + ")";
        } else {
            retour = String.valueOf(retour) + this.getInferenceName();
        }
        return retour;
    }

    public final void init(Hashtable<String, String> params) {
        this.myparams = params;
        String inf_side_nb = params.get("inferenceSideNb");
        if (inf_side_nb != null) {
            String[] inf_split = inf_side_nb.split("-");
            this.setInferenceName(String.valueOf(inf_split[0]) + "-Q_" + Integer.parseInt(inf_split[1]));
        } else {
            String known_names = params.get("knownNames");
            String search_names = params.get("searchNames");
            if (known_names != null) {
                String[] k_names_split = known_names.split("#");
                this.setKnownVarNames(k_names_split);
            } else {
                System.out.println("ProbabilisticDistribution::init -warning:\n\t" + params + "\n\tknownNames field not filled");
            }
            if (search_names != null) {
                String[] s_names_split = search_names.split("#");
                this.setSearchVarNames(s_names_split);
            } else {
                System.out.println(String.valueOf(this.getClass().getName()) + " -error:\n\t" + params + "\n\tsearchNames field not filled");
                System.exit(1);
            }
        }
        String paramNames = params.get("paramNames");
        if (paramNames != null) {
            String[] var_n = paramNames.split("#");
            int[] var_index = new int[var_n.length];
            String[] var_names = new String[var_n.length];
            int i = 0;
            while (i < var_names.length) {
                String[] var_st = var_n[i].split(":");
                var_names[i] = var_st[0];
                var_index[i] = Integer.parseInt(var_st[1]);
                if (var_st[0] == null || var_st[0].equals("")) {
                    System.out.println(String.valueOf(this.getClass().getName()) + "::init -warning:" + this.getName() + " paramNames[" + i + "]=cte=" + var_index[i]);
                }
                ++i;
            }
            this.setParamIndex(var_index);
            this.setParamNames(var_names);
        }
        this.subInit(params);
    }

    public String toString() {
        String s = "<" + this.getClass().getName() + ">\n" + this.toShortString() + "\n";
        s = String.valueOf(s) + "</" + this.getClass().getName() + ">";
        return s;
    }

    protected String toShortString() {
        String s = "\t<Name=" + this.getName() + "\n\tParamNames=";
        if (this.getParamNames() != null) {
            int i = 0;
            while (i < this.getParamNames().length) {
                s = String.valueOf(s) + this.getParamName(i) + ":" + this.getParamIndex(i);
                if (i != this.getParamNames().length - 1) {
                    s = String.valueOf(s) + " # ";
                }
                ++i;
            }
        } else {
            s = String.valueOf(s) + "null";
        }
        return s;
    }

    protected final int getPar1(Hashtable<String, RandomVariable> vars) {
        return this.getPar(vars, 0);
    }

    protected final int getPar2(Hashtable<String, RandomVariable> vars) {
        return this.getPar(vars, 1);
    }

    protected final int getPar3(Hashtable<String, RandomVariable> vars) {
        return this.getPar(vars, 2);
    }

    protected final int getPar4(Hashtable<String, RandomVariable> vars) {
        return this.getPar(vars, 3);
    }

    private final int getPar(Hashtable<String, RandomVariable> vars, int parNb) {
        if (this.getParamNames() != null) {
            String par_name = this.getParamName(parNb);
            if (par_name != null && !par_name.equals("")) {
                RandomVariable var = vars.get(par_name);
                if (var != null) {
                    return var.getListVar(this.getParamIndex(parNb));
                }
                System.out.println("ProbabilisticDistribution (" + this.getClass().getName() + ";" + this.getName() + ") ::getPar -error: " + parNb + "th var name [" + par_name + "] does not exist\n");
                Exception e = new Exception("Just for the stack trace");
                e.printStackTrace();
                System.exit(1);
                return 1;
            }
            return this.getParamIndex(parNb);
        }
        System.out.println("ProbabilisticDistribution (" + this.getClass().getName() + ";" + this.getName() + ") ::getPar" + parNb + " -error: paramNames field not filled");
        Exception e = new Exception("Just for the stack trace");
        e.printStackTrace();
        System.exit(1);
        return 1;
    }

    public abstract double getValue(Hashtable<String, RandomVariable> var1) throws Exception;

    public abstract void setNewValue(Hashtable<String, RandomVariable> var1, double var2);

    public abstract void updateValues();

    protected abstract void subInit(Hashtable<String, String> var1);

    protected abstract void newComputationReset(Hashtable<String, RandomVariable> var1);
}

