/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.GridProbabilisticDistribution;
import engine.RandomVariable;
import java.util.Hashtable;
import utils.GridReferenceConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPD_Table4D
extends GridProbabilisticDistribution {
    private double[][][][] myNewValues;
    private double[][][][] myValues;

    private final double[][][][] getNewValues() {
        return this.myNewValues;
    }

    private final void setNewValues(double[][][][] myNewValues) {
        this.myNewValues = myNewValues;
    }

    private final void setNewValue(int x1, int x2, int x3, int x4, double newVal) {
        System.out.println(String.valueOf(this.getClass().getName()) + "::setNewValue <- " + newVal);
        this.myNewValues[x1][x2][x3][x4] = newVal;
    }

    private final double[][][][] getValues() {
        return this.myValues;
    }

    private final void setValues(double[][][][] Values) {
        this.myValues = Values;
    }

    private final void setValue(int x1, int x2, int x3, int x4, double val) {
        this.myValues[x1][x2][x3][x4] = val;
    }

    protected GPD_Table4D() {
    }

    public GPD_Table4D(GridReferenceConverter refConv) {
        super(refConv);
    }

    @Override
    protected final void subSubInit(Hashtable<String, String> params) {
        int d1_nb = this.getGridRefConverter().getPixelWidth();
        int d2_nb = this.getGridRefConverter().getPixelHeight();
        this.setValues(new double[d1_nb][d2_nb][d1_nb][d2_nb]);
        this.setNewValues(new double[d1_nb][d2_nb][d1_nb][d2_nb]);
        if (params.get("initType").equals("priorInit")) {
            this.initPriorTable(params);
        }
    }

    private final void initPriorTable(Hashtable<String, String> params) {
        String msg = String.valueOf(this.getClass().getName()) + "::initPriorTable -infos: " + this.getName();
        if (params.get("priorType").equals("uniform")) {
            double value = Double.parseDouble(params.get("priorUniformVal"));
            int i1 = 0;
            while (i1 < this.getValues().length) {
                int i2 = 0;
                while (i2 < this.getValues()[i1].length) {
                    int i3 = 0;
                    while (i3 < this.getValues()[i1][i2].length) {
                        int i4 = 0;
                        while (i4 < this.getValues()[i1][i2][i3].length) {
                            this.setValue(i1, i2, i3, i4, value);
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        }
        if (params.get("priorType").equals("uniformIfX1X2NotZero")) {
            String[] zeroPos = params.get("X1X2ZeroPos").split(",");
            int zeroPosx = Integer.parseInt(zeroPos[0]);
            int zeroPosy = Integer.parseInt(zeroPos[1]);
            double val1 = Double.parseDouble(params.get("priorUniformVal"));
            double val2 = Double.parseDouble(params.get("priorUniformValIfX1X2NotZero"));
            int i1 = 0;
            while (i1 < this.getValues().length) {
                int i2 = 0;
                while (i2 < this.getValues()[i1].length) {
                    int i3 = 0;
                    while (i3 < this.getValues()[i1][i2].length) {
                        int i4 = 0;
                        while (i4 < this.getValues()[i1][i2][i3].length) {
                            if (i1 != zeroPosx || i2 != zeroPosy) {
                                this.setValue(i1, i2, i3, i4, val2);
                            } else {
                                this.setValue(i1, i2, i3, i4, val1);
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        }
    }

    @Override
    public final double getValue(Hashtable<String, RandomVariable> vars) throws Exception {
        int entry0 = this.getPar1(vars);
        int entry1 = this.getPar2(vars);
        int entry2 = this.getPar3(vars);
        int entry3 = this.getPar4(vars);
        return this.getValues()[entry0][entry1][entry2][entry3];
    }

    @Override
    public final void setNewValue(Hashtable<String, RandomVariable> vars, double newProba) {
        int entry0 = this.getPar1(vars);
        int entry1 = this.getPar2(vars);
        int entry2 = this.getPar3(vars);
        int entry3 = this.getPar4(vars);
        this.setNewValue(entry0, entry1, entry2, entry3, newProba);
    }

    @Override
    public final void updateValues() {
        this.setValues(this.getNewValues());
    }

    @Override
    protected void setProbaGrid(Hashtable<String, RandomVariable> vars, String probaVarName) {
        if (this.getSearchVarName(0).equals(probaVarName)) {
            RandomVariable k_var = vars.get(this.getKnownVarName(0));
            if (k_var != null) {
                int entry0 = k_var.getListVar(0);
                int entry1 = k_var.getListVar(1);
                this.setGridValues(this.getValues()[entry0][entry1]);
                this.setGridValuesSet(true);
            } else {
                String msg = String.valueOf(this.getClass().getName()) + "::setProbaGrid " + this.getName() + " -error: probaVarName[" + probaVarName + "] is not in " + "the RandomVariable Hashtable (preferredVarName[" + this.getPreferedVariableName() + "])";
                System.out.println(msg);
                System.exit(1);
            }
        }
        this.getKnownVarName(0).equals(probaVarName);
    }

    @Override
    protected final void newComputationReset(Hashtable<String, RandomVariable> vars) {
    }
}

