/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.Cell;
import engine.DebugPolicy;
import engine.LeftRight_GridProbabilisticDistribution;
import engine.LeftRight_Variable;
import engine.Mark;
import engine.Observation;
import engine.ProbabilisticDistribution;
import engine.RandomVariable;
import engine.Saccade;
import engine.ShowableException;
import engine.Target;
import gui.MVC_Event;
import gui.MVC_Event_Type;
import gui.MVC_SpotEvent;
import gui.Model;
import gui.View;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import utils.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BossEngine
implements Model {
    private static double OBSERVATION_DEFAULT_SIZE = 2.0;
    public static String appliVersion = "1.0";
    public static String appliAuthors = "F. Flacher, F. Colas";
    public static String appliDate = "2006-2007";
    public static String appliEmails = "fabien.flacher@gmail.com, francis.colas@college-de-france.fr";
    private int myCurrentTimeStep = 0;
    private Position[][] myObservationInstantSpeed;
    private Position[][] myTargetInstantSpeed;
    private Position[] myEyesInstantSpeed;
    private DebugPolicy myDebugPolicy;
    private Vector<Mark> myMarks = new Vector();
    private Hashtable<String, LeftRight_Variable> myLRVariables = new Hashtable();
    private Hashtable<String, RandomVariable> myVariables = new Hashtable();
    private Vector<LeftRight_GridProbabilisticDistribution> myGridProbaDists = new Vector();
    private Vector<ProbabilisticDistribution> myOthersProbaDists = new Vector();
    private Vector<Observation> myObservations = new Vector();
    private Vector<Target> myTargets = new Vector();
    private LinkedList<Saccade> mySaccades = new LinkedList();
    private Vector<View> myAssociatedViews = new Vector();
    private boolean freeEyes = false;
    private boolean modelEM = false;
    protected Hashtable<String, String> parameters = new Hashtable();
    private boolean killOnStop = false;

    private final void setCurrentTimeStep(int myCTS) {
        this.myCurrentTimeStep = myCTS;
    }

    protected final int getCurrentTimeStep() {
        return this.myCurrentTimeStep;
    }

    private final void incrCurrentTimeStep() {
        ++this.myCurrentTimeStep;
    }

    protected final Position[][] getObservationInstantSpeed() {
        return this.myObservationInstantSpeed;
    }

    private final void setTargetInstantSpeed(Position[][] myTIS) {
        this.myTargetInstantSpeed = myTIS;
    }

    protected final Position[][] getTargetInstantSpeed() {
        return this.myTargetInstantSpeed;
    }

    private final void setObservationInstantSpeed(Position[][] myTIS) {
        this.myObservationInstantSpeed = myTIS;
    }

    private final Position[] getEyesInstantSpeed() {
        return this.myEyesInstantSpeed;
    }

    private final void setEyesInstantSpeed(Position[] myEIS) {
        this.myEyesInstantSpeed = myEIS;
    }

    public final DebugPolicy getDebugPolicy() {
        return this.myDebugPolicy;
    }

    protected final void setDebugPolicy(DebugPolicy debugPolicy) {
        this.myDebugPolicy = debugPolicy;
    }

    protected final Vector<Mark> getMarks() {
        return this.myMarks;
    }

    protected final Hashtable<String, LeftRight_Variable> getLRVariables() {
        return this.myLRVariables;
    }

    protected final RandomVariable getVariable(String name) throws Exception {
        RandomVariable rv = this.myVariables.get(name);
        if (rv == null) {
            String msg = String.valueOf(this.getClass().getName()) + "::getVariable -error: [" + name + "] variable does not exist !\n";
            Enumeration<String> e = this.myVariables.keys();
            while (e.hasMoreElements()) {
                msg = String.valueOf(msg) + e.nextElement() + "\n";
            }
            throw new Exception(msg);
        }
        return rv;
    }

    protected final Hashtable<String, RandomVariable> getVariables() {
        return this.myVariables;
    }

    protected final void setVariable(RandomVariable var) {
        this.myVariables.put(var.getName(), var);
    }

    protected final void setVariable(LeftRight_Variable var) {
        this.setVariable(var.getLeftPart());
        this.setVariable(var.getRightPart());
        this.myLRVariables.put(var.getName(), var);
    }

    protected final Vector<LeftRight_GridProbabilisticDistribution> getGridProbaDists() {
        return this.myGridProbaDists;
    }

    protected final Vector<ProbabilisticDistribution> getOthersProbaDists() {
        return this.myOthersProbaDists;
    }

    protected final LinkedList<Saccade> getSaccades() {
        return this.mySaccades;
    }

    protected final Vector<Observation> getObservations() {
        return this.myObservations;
    }

    protected final Vector<Target> getTargets() {
        return this.myTargets;
    }

    @Override
    public final Vector<View> getAssociatedViews() {
        return this.myAssociatedViews;
    }

    public final boolean isFreeEyes() {
        return this.freeEyes;
    }

    public final void setFreeEyes(boolean freeEyes) {
        this.freeEyes = freeEyes;
    }

    public final boolean isModelEM() {
        return this.modelEM;
    }

    public final void setModelEM(boolean modelEM) {
        this.modelEM = modelEM;
    }

    protected BossEngine() {
    }

    public final void addMark(Position pos, String label) {
        Mark crtM = new Mark(pos, label);
        this.getMarks().add(crtM);
        this.notifyMarkChange(crtM, MVC_Event_Type.MARK_ADD);
    }

    private final void addObservation(Position pos, double size) {
        Observation crtT = new Observation(pos, size);
        this.getObservations().add(crtT);
        this.notifyObservationChange(crtT, MVC_Event_Type.OBSERVATION_ADD);
    }

    private final void addTarget(Position pos, double size) {
        Target crtT = new Target(pos, size);
        this.getTargets().add(crtT);
        this.notifyObservationChange(crtT, MVC_Event_Type.TARGET_ADD);
    }

    private final void addSaccade(Position pos) {
        int time = this.getSaccades().size() - 1;
        Saccade crtS = new Saccade(pos, time);
        this.getSaccades().addFirst(crtS);
        this.notifySaccadeChange(crtS, MVC_Event_Type.SACC_ADD);
    }

    private final void removeObservation(int hashCode) {
        for (Observation crtT : this.getObservations()) {
            if (crtT.hashCode() != hashCode) continue;
            this.getObservations().remove(crtT);
            this.notifyObservationChange(crtT, MVC_Event_Type.OBSERVATION_REM);
            break;
        }
    }

    private final void removeTarget(int hashCode) {
        for (Target crtT : this.getTargets()) {
            if (crtT.hashCode() != hashCode) continue;
            this.getTargets().remove(crtT);
            this.notifyObservationChange(crtT, MVC_Event_Type.TARGET_REM);
            break;
        }
    }

    private final void removeSaccade(int hashCode) {
        for (Saccade crtS : this.getSaccades()) {
            if (crtS.hashCode() != hashCode) continue;
            this.getSaccades().remove(crtS);
            this.notifySaccadeChange(crtS, MVC_Event_Type.SACC_REM);
            break;
        }
    }

    private final void removeMark(int hashCode) {
        for (Mark crtM : this.getMarks()) {
            if (crtM.hashCode() != hashCode) continue;
            this.getMarks().remove(crtM);
            this.notifyMarkChange(crtM, MVC_Event_Type.MARK_REM);
            break;
        }
    }

    private final void moveObservation(Position pos, int hashCode) {
        for (Observation crtT : this.getObservations()) {
            if (crtT.hashCode() != hashCode) continue;
            crtT.position = new Position(pos);
            this.notifyObservationChange(crtT, MVC_Event_Type.OBSERVATION_MOV);
            break;
        }
    }

    private final void moveTarget(Position pos, int hashCode) {
        for (Target crtT : this.getTargets()) {
            if (crtT.hashCode() != hashCode) continue;
            crtT.position = new Position(pos);
            this.notifyObservationChange(crtT, MVC_Event_Type.TARGET_MOV);
            break;
        }
    }

    private final void changeObservationSize(int hashCode, double pctSize) {
        for (Observation crtT : this.getObservations()) {
            if (crtT.hashCode() != hashCode) continue;
            crtT.size *= StrictMath.min(40.0, StrictMath.max(0.2, 1.0 + pctSize));
            this.notifyObservationChange(crtT, MVC_Event_Type.OBSERVATION_SIZE_UPD);
            break;
        }
        try {
            this.updateVariables();
        }
        catch (ShowableException se) {
            this.notifyError(se);
        }
    }

    private final void changeTargetSize(int hashCode, double pctSize) {
        for (Target crtT : this.getTargets()) {
            if (crtT.hashCode() != hashCode) continue;
            crtT.size *= StrictMath.min(40.0, StrictMath.max(0.2, 1.0 + pctSize));
            this.notifyObservationChange(crtT, MVC_Event_Type.TARGET_SIZE_UPD);
            break;
        }
        try {
            this.updateVariables();
        }
        catch (ShowableException se) {
            this.notifyError(se);
        }
    }

    private final void notifyMarkChange(Mark mark, MVC_Event_Type eType) {
        MVC_SpotEvent aMVC_SE = new MVC_SpotEvent(eType, this, mark.position, 0.0, mark.hashCode(), mark.label);
        for (View crtV : this.getAssociatedViews()) {
            crtV.performedM_VC_Event(aMVC_SE);
        }
    }

    private final void notifySaccadeChange(Saccade saccade, MVC_Event_Type eType) {
        MVC_SpotEvent aMVC_SE = new MVC_SpotEvent(eType, this, saccade.position, 0.0, saccade.hashCode(), null);
        for (View crtV : this.getAssociatedViews()) {
            crtV.performedM_VC_Event(aMVC_SE);
        }
    }

    private final void notifyObservationChange(Observation observation, MVC_Event_Type eType) {
        MVC_SpotEvent aMVC_SE = new MVC_SpotEvent(eType, this, observation.position, observation.size, observation.hashCode(), null);
        for (View crtV : this.getAssociatedViews()) {
            crtV.performedM_VC_Event(aMVC_SE);
        }
    }

    private final void moveMark(Position pos, int hashCode) {
        for (Mark crtM : this.getMarks()) {
            if (crtM.hashCode() != hashCode) continue;
            crtM.position = new Position(pos);
            this.notifyMarkChange(crtM, MVC_Event_Type.MARK_MOV);
            break;
        }
    }

    private final void moveSaccade(Position pos, int hashCode) {
        for (Saccade crtS : this.getSaccades()) {
            if (crtS.hashCode() != hashCode) continue;
            crtS.position = new Position(pos);
            this.notifySaccadeChange(crtS, MVC_Event_Type.SACC_MOV);
            break;
        }
    }

    private final void applySaccade(int hashCode, boolean to_all) {
        Position sacc_pos = null;
        for (Saccade saccade : this.getSaccades()) {
            if (saccade.hashCode() != hashCode) continue;
            sacc_pos = saccade.position;
            break;
        }
        for (Observation observation : this.getObservations()) {
            observation.position.applyRef1Translation(sacc_pos, false);
            this.notifyObservationChange(observation, MVC_Event_Type.OBSERVATION_MOV);
        }
        for (Target target : this.getTargets()) {
            target.position.applyRef1Translation(sacc_pos, false);
            this.notifyObservationChange(target, MVC_Event_Type.TARGET_MOV);
        }
        if (to_all) {
            for (Saccade saccade : this.getSaccades()) {
                saccade.position.applyRef1Translation(sacc_pos, false);
                this.notifySaccadeChange(saccade, MVC_Event_Type.SACC_MOV);
            }
        }
        for (Mark mark : this.getMarks()) {
            mark.position.applyRef1Translation(sacc_pos, false);
            this.notifyMarkChange(mark, MVC_Event_Type.MARK_MOV);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void loadEM(String path) {
        block7: {
            t_msg = null;
            m_msg = null;
            try {
                reader = new BufferedReader(new FileReader(path));
                lines = new Vector<String>();
                while (reader.ready()) {
                    lines.add(reader.readLine());
                }
                crt_pos = null;
                t_msg = "Pb in reading the 2nd lines of the file";
                crt_pos = ((String)lines.get(0)).split(",");
                m_msg = "Impossible to read position of the eye";
                x1 = Double.parseDouble(crt_pos[0]);
                y1 = Double.parseDouble(crt_pos[1]);
                last_pos = new Position(x1, y1, true);
                if (this.getSaccades().isEmpty()) {
                    this.addSaccade(last_pos);
                } else {
                    this.getSaccades().get((int)0).position = last_pos;
                    this.notifySaccadeChange(this.getSaccades().get(0), MVC_Event_Type.SACC_MOV);
                }
                t_msg = "Pb in reading the other lines (3rd to ...) of the file";
                instant_speeds = new Position[lines.size() - 1];
                i = 1;
                while (i < lines.size()) {
                    crt_pos = ((String)lines.get(i)).split(",");
                    m_msg = "Impossible to read position of the eye in the " + (i + 1) + "th line\n";
                    m_msg = String.valueOf(m_msg) + " -> " + i + "th line: [" + (String)lines.get(i - 1) + "]\n";
                    m_msg = String.valueOf(m_msg) + " -> " + (i + 1) + "th line: [" + (String)lines.get(i) + "]\n";
                    x1 = Double.parseDouble(crt_pos[0]);
                    y1 = Double.parseDouble(crt_pos[1]);
                    instant_speeds[i - 1] = new Position(x1, y1, true);
                    ++i;
                }
                this.setEyesInstantSpeed(instant_speeds);
                break block7;
            }
            catch (Exception e) {
                ** for (crtV : this.getAssociatedViews())
            }
lbl-1000:
            // 1 sources

            {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.MSG_ERR, this, String.valueOf(t_msg) + "$" + m_msg, null));
                continue;
            }
lbl42:
            // 1 sources

            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void load(String path) {
        block13: {
            t_msg = null;
            m_msg = null;
            try {
                reader = new BufferedReader(new FileReader(path));
                t_msg = "Pb in reading the first line of the file";
                first_line = reader.readLine();
                m_msg = "Impossible to split by #";
                observation_caracs = first_line.split("#");
                m_msg = "Impossible to read observation number (1st carac)";
                observation_nb = Integer.parseInt(observation_caracs[0]);
                m_msg = "Impossible to read observation xSize (2nd carac)";
                observation_size = Double.parseDouble(observation_caracs[1]);
                m_msg = "Impossible to read observation color (3rd carac)";
                observation_color = Integer.parseInt(observation_caracs[2]);
                m_msg = "Impossible to read distractor index (4th carac)";
                targets = observation_caracs[3].split(",");
                target_indices = new Vector<Integer>(targets.length);
                i = 0;
                while (i < targets.length) {
                    target_indices.add(Integer.parseInt(targets[i]));
                    ++i;
                }
                lines = new Vector<String>();
                while (reader.ready()) {
                    lines.add(reader.readLine());
                }
                last_pos = new Position[observation_nb];
                crt_pos = null;
                crt_line = ((String)lines.get(0)).split("#");
                if (crt_line.length != observation_nb) {
                    t_msg = "Pb in reading the file";
                    m_msg = "The number of observation in the 1st line (" + observation_nb + ") does not\n" + "correspond to the number of observation position " + "described\n in the following lines of the file (" + crt_line.length + ")";
                    throw new Exception();
                }
                t_msg = "Pb in reading the 2nd lines of the file";
                index_map = new int[observation_nb];
                i = 0;
                while (i < crt_line.length) {
                    crt_pos = crt_line[i].split(",");
                    m_msg = "Impossible to read position of the " + (i + 1) + "th observation";
                    x1 = Double.parseDouble(crt_pos[0]);
                    y1 = Double.parseDouble(crt_pos[1]);
                    last_pos[i] = new Position(x1, y1, true);
                    if (target_indices.contains(i + 1)) {
                        index_map[i] = this.getTargets().size();
                        this.addTarget(last_pos[i], observation_size);
                    } else {
                        index_map[i] = this.getObservations().size();
                        this.addObservation(last_pos[i], observation_size);
                    }
                    ++i;
                }
                t_msg = "Pb in reading the other lines (3rd to ...) of the file";
                obs_instant_speeds = new Position[lines.size() - 1][observation_nb - target_indices.size()];
                tgt_instant_speeds = new Position[lines.size() - 1][target_indices.size()];
                i = 1;
                while (i < lines.size()) {
                    crt_line = ((String)lines.get(i)).split("#");
                    j = 0;
                    while (j < crt_line.length) {
                        crt_pos = crt_line[j].split(",");
                        m_msg = "Impossible to read position of the " + (j + 1) + "th " + "observation of the " + (i + 1) + "th line\n";
                        m_msg = String.valueOf(m_msg) + " -> " + i + "th line: [" + (String)lines.get(i - 1) + "]\n";
                        m_msg = String.valueOf(m_msg) + " -> " + (i + 1) + "th line: [" + (String)lines.get(i) + "]\n";
                        x1 = Double.parseDouble(crt_pos[0]);
                        y1 = Double.parseDouble(crt_pos[1]);
                        sx1 = last_pos[j].getX1() - x1;
                        sy1 = last_pos[j].getY1() - y1;
                        if (target_indices.contains(j + 1)) {
                            tgt_instant_speeds[i - 1][index_map[j]] = new Position(sx1, sy1, true);
                        } else {
                            obs_instant_speeds[i - 1][index_map[j]] = new Position(sx1, sy1, true);
                        }
                        last_pos[j] = new Position(x1, y1, true);
                        ++j;
                    }
                    ++i;
                }
                this.setObservationInstantSpeed(obs_instant_speeds);
                this.setTargetInstantSpeed(tgt_instant_speeds);
                this.addSaccade(new Position(0.0, 0.0, true));
                break block13;
            }
            catch (Exception e) {
                ** for (crtV : this.getAssociatedViews())
            }
lbl-1000:
            // 1 sources

            {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.MSG_ERR, this, String.valueOf(t_msg) + "$" + m_msg, null));
                continue;
            }
lbl87:
            // 1 sources

            e.printStackTrace();
        }
        this.setCurrentTimeStep(0);
        this.flash();
    }

    private final void actualizeObservationPositions() {
        block7: {
            block5: {
                block6: {
                    if (this.getObservationInstantSpeed() == null) break block5;
                    if (this.getCurrentTimeStep() >= this.getObservationInstantSpeed().length) break block6;
                    Position crt_instant_speed = null;
                    int i = 0;
                    while (i < this.getObservations().size()) {
                        crt_instant_speed = this.getObservationInstantSpeed()[this.getCurrentTimeStep()][i];
                        this.getObservations().get((int)i).position.applyRef1Translation(crt_instant_speed, false);
                        this.notifyObservationChange(this.getObservations().get(i), MVC_Event_Type.OBSERVATION_MOV);
                        ++i;
                    }
                    i = 0;
                    while (i < this.getTargets().size()) {
                        crt_instant_speed = this.getTargetInstantSpeed()[this.getCurrentTimeStep()][i];
                        this.getTargets().get((int)i).position.applyRef1Translation(crt_instant_speed, false);
                        this.notifyObservationChange(this.getTargets().get(i), MVC_Event_Type.TARGET_MOV);
                        ++i;
                    }
                    break block7;
                }
                for (View crtV : this.getAssociatedViews()) {
                    crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.STOP, this, null, null));
                }
                this.solveTask();
                if (!this.isKillOnStop()) break block7;
                System.exit(0);
                break block7;
            }
            String t_msg = "Error";
            String m_msg = "You need to load an observation trajectories file";
            for (View crtV : this.getAssociatedViews()) {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.MSG_ERR, this, String.valueOf(t_msg) + "$" + m_msg, null));
            }
            for (View crtV : this.getAssociatedViews()) {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.STOP, this, null, null));
            }
        }
    }

    private void actualizeEyeMovements() {
        Saccade act_saccade = this.getSaccades().get(0);
        if (this.isModelEM()) {
            Position new_pos = this.decideSaccade(-1);
            System.out.println("Decision on new eye position: " + new_pos.toString());
            act_saccade.position.applyRef1Translation(new_pos, true);
            this.notifySaccadeChange(act_saccade, MVC_Event_Type.SACC_MOV);
        } else if (this.getEyesInstantSpeed() != null) {
            if (this.getCurrentTimeStep() < this.getEyesInstantSpeed().length) {
                Position crt_instant_speed = this.getEyesInstantSpeed()[this.getCurrentTimeStep() - 1];
                act_saccade.position.applyRef1Translation(crt_instant_speed, true);
                this.notifySaccadeChange(act_saccade, MVC_Event_Type.SACC_MOV);
            } else {
                for (View crtV : this.getAssociatedViews()) {
                    crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.STOP, this, null, null));
                }
            }
        } else {
            String t_msg = "Error";
            String m_msg = "You need to load an eye movement trajectory file";
            for (View crtV : this.getAssociatedViews()) {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.MSG_ERR, this, String.valueOf(t_msg) + "$" + m_msg, null));
            }
            for (View crtV : this.getAssociatedViews()) {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.STOP, this, null, null));
            }
            return;
        }
    }

    protected final void notifyError(ShowableException e) {
        for (View crtV : this.getAssociatedViews()) {
            crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.MSG_ERR, this, e.getMessage(), null));
        }
    }

    protected final void clearAll() {
        for (Observation crtO : this.getObservations()) {
            this.notifyObservationChange(crtO, MVC_Event_Type.OBSERVATION_REM);
        }
        this.getObservations().clear();
        for (Target crtT : this.getTargets()) {
            this.notifyObservationChange(crtT, MVC_Event_Type.TARGET_REM);
        }
        this.getTargets().clear();
        for (Saccade crtS : this.getSaccades()) {
            this.notifySaccadeChange(crtS, MVC_Event_Type.SACC_REM);
        }
        this.getSaccades().clear();
    }

    @Override
    public final boolean performedVC_M_Event(MVC_Event aMVCEvt) {
        aMVCEvt.traceDebug(String.valueOf(this.getClass().getName()) + "::performedM_VC_Event");
        switch (aMVCEvt.getIdentity()) {
            case INFERE: {
                this.infer();
                return true;
            }
            case FLASH_TARGETS: {
                this.flash();
                return true;
            }
            case INFOS: {
                this.getCellInfos((Position)aMVCEvt.getData()[0][0], (String)aMVCEvt.getData()[1][0]);
                return true;
            }
            case INIT_APPLI: {
                Hashtable<String, String> params = new Hashtable<String, String>();
                Object[][] data = aMVCEvt.getData();
                params.put("cellWidth", "" + data[0][0]);
                params.put("cellHeight", "" + data[0][1]);
                params.put("killOnStop", "" + data[0][2]);
                params.put("paramFile", (String)data[0][3]);
                this.init(params);
                return true;
            }
            case ITERE: {
                this.applySaccade(this.getSaccades().get(0).hashCode(), false);
                this.incrCurrentTimeStep();
                this.infer();
                if (this.isFreeEyes()) {
                    this.getSaccades().get((int)0).position.applyRef1Translation(this.getSaccades().get((int)0).position, false);
                    this.notifySaccadeChange(this.getSaccades().get(0), MVC_Event_Type.SACC_MOV);
                }
                this.actualizeObservationPositions();
                if (this.isFreeEyes()) {
                    this.actualizeEyeMovements();
                }
                this.evaluateModels();
                return true;
            }
            case LOAD: {
                this.load((String)aMVCEvt.getData()[0][0]);
                return true;
            }
            case LOAD_EM: {
                this.loadEM((String)aMVCEvt.getData()[0][0]);
                return true;
            }
            case MARK_ADD: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.addMark(sEvt.position, sEvt.label);
                return true;
            }
            case MARK_REM: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.removeMark(sEvt.hashCode);
                return true;
            }
            case RESET: {
                this.setCurrentTimeStep(0);
                this.clearAll();
                return true;
            }
            case SACC_ADD: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.addSaccade(sEvt.position);
                return true;
            }
            case SACC_APP: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.applySaccade(sEvt.hashCode, true);
                try {
                    this.updateVariables();
                }
                catch (ShowableException se) {
                    this.notifyError(se);
                }
                return true;
            }
            case SACC_MOV: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.moveSaccade(sEvt.position, sEvt.hashCode);
                try {
                    this.updateVariables();
                }
                catch (ShowableException se) {
                    this.notifyError(se);
                }
                return true;
            }
            case SACC_REM: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.removeSaccade(sEvt.hashCode);
                return true;
            }
            case OBSERVATION_ADD: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.addObservation(sEvt.position, OBSERVATION_DEFAULT_SIZE);
                return true;
            }
            case OBSERVATION_MOV: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.moveObservation(sEvt.position, sEvt.hashCode);
                try {
                    this.updateVariables();
                }
                catch (ShowableException se) {
                    this.notifyError(se);
                }
                return true;
            }
            case OBSERVATION_REM: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.removeObservation(sEvt.hashCode);
                return true;
            }
            case OBSERVATION_SIZE_DEC: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.changeObservationSize(sEvt.hashCode, -0.2);
                return true;
            }
            case OBSERVATION_SIZE_INC: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.changeObservationSize(sEvt.hashCode, 0.2);
                return true;
            }
            case TARGET_ADD: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.addTarget(sEvt.position, OBSERVATION_DEFAULT_SIZE);
                return true;
            }
            case TARGET_MOV: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.moveTarget(sEvt.position, sEvt.hashCode);
                try {
                    this.updateVariables();
                }
                catch (ShowableException se) {
                    this.notifyError(se);
                }
                return true;
            }
            case TARGET_REM: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.removeTarget(sEvt.hashCode);
                return true;
            }
            case TARGET_SIZE_DEC: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.changeTargetSize(sEvt.hashCode, -0.2);
                return true;
            }
            case TARGET_SIZE_INC: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.changeTargetSize(sEvt.hashCode, 0.2);
                return true;
            }
            case UPDATE: {
                try {
                    this.updateVariables();
                }
                catch (ShowableException se) {
                    this.notifyError(se);
                }
                return true;
            }
            case FREE_EYES: {
                this.setFreeEyes(true);
                return true;
            }
            case FIXED_EYES: {
                this.setFreeEyes(false);
                return true;
            }
            case MODEL_EM: {
                this.setModelEM(true);
                return true;
            }
            case DATA_EM: {
                this.setModelEM(false);
                return true;
            }
        }
        return false;
    }

    private final void init(Hashtable<String, String> params) {
        Object[][] data2 = Cell.init(params);
        this.setKillOnStop(new Boolean(params.get("killOnStop")));
        String paramFile = params.get("paramFile");
        if (paramFile != "") {
            this.loadParameters(paramFile);
        }
        this.initRandomVariables();
        this.initProbaDistributions();
        Object[][] data1 = new Object[][]{{this.getGridProbaDists()}, {this.getLRVariables()}};
        Vector viewsClone = (Vector)this.getAssociatedViews().clone();
        for (View crtView : viewsClone) {
            crtView.performedM_VC_Event(new MVC_Event(MVC_Event_Type.INIT_APPLI, this, data1));
        }
        data2[4][0] = this.getOthersProbaDists();
        data2[5][0] = this.getGridProbaDists();
        for (View crtView : this.getAssociatedViews()) {
            crtView.performedM_VC_Event(new MVC_Event(MVC_Event_Type.INIT, this, data2));
        }
    }

    protected final void notifyUpdate() {
        Object[][] data = new Object[][]{{this.getVariables(), this.getGridProbaDists()}, {this.getOthersProbaDists()}};
        for (View crtV : this.getAssociatedViews()) {
            crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.UPDATE, this, data));
        }
        String crtT = "" + this.getCurrentTimeStep();
        for (View crtV : this.getAssociatedViews()) {
            crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.UPTIME, this, crtT, null));
        }
    }

    protected abstract void updateVariables() throws ShowableException;

    private final void infer() {
        for (LeftRight_GridProbabilisticDistribution gpd : this.getGridProbaDists()) {
            gpd.newComputationReset(this.getVariables());
        }
        for (ProbabilisticDistribution pd : this.getOthersProbaDists()) {
            pd.newComputationReset(this.getVariables());
        }
        this.subInfer();
    }

    protected void flash() {
    }

    public static void main(String[] args) {
        int nb_steps = 590;
        int observation_nb = 6;
        double observation_size = 2.7;
        int observation_color = 255;
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 4;
        int[] distractors_index = nArray;
        Random R = new Random(15091978L);
        double x_size = 50.0;
        double y_size = 50.0;
        double x_spd_step = 0.053;
        double y_spd_step = 0.11;
        double x_spd_max = 0.53;
        double y_spd_max = 1.1;
        double[] x_pos = new double[observation_nb];
        double[] y_pos = new double[observation_nb];
        double[] x_spd = new double[observation_nb];
        double[] y_spd = new double[observation_nb];
        System.out.print(String.valueOf(observation_nb) + "#" + observation_size + "#" + observation_color + "#");
        int i = 0;
        while (i < distractors_index.length) {
            System.out.print("" + distractors_index[i]);
            if (i != distractors_index.length - 1) {
                System.out.print(",");
            }
            ++i;
        }
        System.out.println("");
        i = 0;
        while (i < observation_nb) {
            x_pos[i] = 2.0 * x_size * R.nextDouble() - x_size;
            x_spd[i] = 2.0 * x_spd_max * R.nextDouble() - x_spd_max;
            y_pos[i] = 2.0 * y_size * R.nextDouble() - y_size;
            y_spd[i] = 2.0 * y_spd_max * R.nextDouble() - y_spd_max;
            ++i;
        }
        double x_tir = 0.0;
        double y_tir = 0.0;
        double sq_dist = 0.0;
        double radius_max = 6400.0;
        int i2 = 0;
        while (i2 < nb_steps) {
            String msg = "";
            int j = 0;
            while (j < observation_nb) {
                msg = String.valueOf(msg) + x_pos[j] + "," + y_pos[j];
                if (j != observation_nb - 1) {
                    msg = String.valueOf(msg) + "#";
                }
                if (R.nextDouble() <= 0.1) {
                    x_tir = R.nextDouble();
                    x_spd[j] = x_tir < 0.5 ? StrictMath.max(-x_spd_max, StrictMath.min(x_spd_max, x_spd[j] + x_spd_step)) : StrictMath.max(-x_spd_max, StrictMath.min(x_spd_max, x_spd[j] - x_spd_step));
                }
                if (R.nextDouble() <= 0.1) {
                    y_tir = R.nextDouble();
                    if (y_tir < 0.5) {
                        int n = j;
                        y_pos[n] = y_pos[n] + StrictMath.max(-y_spd_max, StrictMath.min(y_spd_max, y_spd[j] + y_spd_step));
                    } else {
                        int n = j;
                        y_pos[n] = y_pos[n] + StrictMath.max(-y_spd_max, StrictMath.min(y_spd_max, y_spd[j] - y_spd_step));
                    }
                }
                if ((sq_dist = StrictMath.pow(x_pos[j] + x_spd[j], 2.0) + StrictMath.pow(y_pos[j] + y_spd[j], 2.0)) > radius_max) {
                    x_spd[j] = -x_spd[j];
                    y_spd[j] = -y_spd[j];
                }
                int n = j;
                x_pos[n] = x_pos[n] + x_spd[j];
                int n2 = j;
                y_pos[n2] = y_pos[n2] + y_spd[j];
                ++j;
            }
            System.out.println(msg);
            ++i2;
        }
        System.out.println("end");
    }

    protected abstract void getCellInfos(Position var1, String var2);

    protected abstract void subInfer();

    protected abstract Position decideSaccade(int var1);

    protected void evaluateModels() {
        if (this.isFreeEyes()) {
            this.isModelEM();
        }
    }

    protected abstract int[] solveTask();

    protected abstract void initRandomVariables();

    protected abstract void initProbaDistributions();

    protected String getParameter(String key) throws NullPointerException {
        String res = this.parameters.get(key);
        if (res == null) {
            throw new NullPointerException();
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    protected void loadParameters(String filename) {
        block8: {
            t_msg = "Error";
            m_msg = null;
            try {
                reader = new BufferedReader(new FileReader(filename));
                lines = new Vector<String>();
                while (reader.ready()) {
                    lines.add(reader.readLine());
                }
                i = 1;
                while (i < lines.size()) {
                    stripped_line = ((String)lines.get(i)).split("#", 2)[0].trim();
                    m_msg = "Impossible to parse configuration line " + (i + 1) + "\n";
                    m_msg = String.valueOf(m_msg) + " -> " + i + "th line: [" + (String)lines.get(i - 1) + "]\n";
                    m_msg = String.valueOf(m_msg) + " -> " + (i + 1) + "th line: [" + (String)lines.get(i) + "]\n";
                    if (!stripped_line.equals("")) {
                        parsed_line = stripped_line.split("=", 2);
                        if (!parsed_line[1].trim().equals("")) {
                            this.parameters.put(parsed_line[0].trim(), parsed_line[1].trim());
                        } else {
                            throw new NullPointerException();
                        }
                    }
                    ++i;
                }
                break block8;
            }
            catch (Exception e) {
                ** for (crtV : this.getAssociatedViews())
            }
lbl-1000:
            // 1 sources

            {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.MSG_ERR, this, String.valueOf(t_msg) + "$" + m_msg, null));
                continue;
            }
lbl31:
            // 1 sources

            e.printStackTrace();
        }
    }

    protected final boolean isKillOnStop() {
        return this.killOnStop;
    }

    protected final void setKillOnStop(boolean killOnStop) {
        this.killOnStop = killOnStop;
    }
}

